/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.jdbc;

import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnderInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Locale;

public class JavaCollation
extends SqlCollation {
    private final Collator collator;
    private static final String STRENGTH_PRIMARY = "primary";
    private static final String STRENGTH_SECONDARY = "secondary";
    private static final String STRENGTH_TERTIARY = "tertiary";
    private static final String STRENGTH_IDENTICAL = "identical";

    public JavaCollation(SqlCollation.Coercibility coercibility, Locale locale, Charset charset, int strength) {
        super(coercibility, locale, charset, JavaCollation.getStrengthString(strength));
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(strength);
    }

    private static String getStrengthString(int strengthValue) {
        switch (strengthValue) {
            case 0: {
                return STRENGTH_PRIMARY;
            }
            case 1: {
                return STRENGTH_SECONDARY;
            }
            case 2: {
                return STRENGTH_TERTIARY;
            }
            case 3: {
                return STRENGTH_IDENTICAL;
            }
        }
        throw new IllegalArgumentException("Incorrect strength value.");
    }

    @Override
    protected String generateCollationName(@UnderInitialization JavaCollation this, Charset charset) {
        return super.generateCollationName(charset) + "$JAVA_COLLATOR";
    }

    @Override
    public @Nullable Collator getCollator() {
        return this.collator;
    }
}

