/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica.remote;

import com.hazelcast.org.apache.calcite.avatica.remote.AuthenticationType;
import com.hazelcast.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.hazelcast.org.apache.calcite.avatica.remote.GSSAuthenticateable;
import com.hazelcast.org.apache.calcite.avatica.remote.HttpClientPoolConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.ietf.jgss.GSSCredential;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
HttpClientPoolConfigurable,
UsernamePasswordAuthenticateable,
GSSAuthenticateable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final boolean USE_CANONICAL_HOSTNAME = Boolean.parseBoolean(System.getProperty("avatica.http.spnego.use_canonical_hostname", "true"));
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;
    protected final HttpHost host;
    protected final URI uri;
    protected BasicAuthCache authCache;
    protected CloseableHttpClient client;
    protected Registry<ConnectionSocketFactory> socketFactoryRegistry;
    protected PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeProvider> authRegistry = null;
    protected Object userToken;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.uri = AvaticaCommonsHttpClientImpl.toURI(Objects.requireNonNull(url));
    }

    protected void initializeClient(PoolingHttpClientConnectionManager pool) {
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pool).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            HttpClientContext context = HttpClientContext.create();
            context.setTargetHost(this.host);
            if (null != this.credentialsProvider) {
                context.setCredentialsProvider(this.credentialsProvider);
                context.setAuthSchemeRegistry(this.authRegistry);
                context.setAuthCache((AuthCache)this.authCache);
            }
            if (null != this.userToken) {
                context.setUserToken(this.userToken);
            }
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity((HttpEntity)entity);
            try {
                CloseableHttpResponse response = this.execute(post, context);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (200 == statusCode || 500 == statusCode) {
                        this.userToken = context.getUserToken();
                        byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                        return byArray;
                    }
                    if (503 == statusCode) {
                        LOG.debug("Failed to connect to server (HTTP/503), retrying");
                        continue;
                    }
                    throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    CloseableHttpResponse execute(HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.execute((HttpUriRequest)post, (HttpContext)context);
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
        RegistryBuilder authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", (Object)new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", (Object)new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
    }

    @Override
    public void setGSSCredential(GSSCredential credential) {
        this.authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, USE_CANONICAL_HOSTNAME)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
        } else {
            this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)EmptyCredentials.INSTANCE);
        }
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setHttpClientPool(PoolingHttpClientConnectionManager pool) {
        this.initializeClient(pool);
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }
}

