/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica;

import com.hazelcast.org.apache.calcite.avatica.AvaticaUtils;
import com.hazelcast.org.apache.calcite.avatica.BuiltInConnectionProperty;
import com.hazelcast.org.apache.calcite.avatica.ConnectionConfig;
import com.hazelcast.org.apache.calcite.avatica.ConnectionProperty;
import com.hazelcast.org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import com.hazelcast.org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.Service;
import java.io.File;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ConnectionConfigImpl
implements ConnectionConfig {
    protected final Properties properties;
    public static final Converter<Boolean> BOOLEAN_CONVERTER = new Converter<Boolean>(){

        @Override
        public Boolean apply(ConnectionProperty connectionProperty, String s2) {
            if (s2 == null) {
                throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
            }
            return Boolean.parseBoolean(s2);
        }
    };
    static final Map<String, BigDecimal> MULTIPLIER_MAP = new LinkedHashMap<String, BigDecimal>();
    public static final Converter<Number> NUMBER_CONVERTER;
    public static final Converter<String> IDENTITY_CONVERTER;

    public ConnectionConfigImpl(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String schema() {
        return BuiltInConnectionProperty.SCHEMA.wrap(this.properties).getString();
    }

    @Override
    public String timeZone() {
        return BuiltInConnectionProperty.TIME_ZONE.wrap(this.properties).getString();
    }

    @Override
    public Service.Factory factory() {
        return BuiltInConnectionProperty.FACTORY.wrap(this.properties).getPlugin(Service.Factory.class, null);
    }

    @Override
    public String url() {
        return BuiltInConnectionProperty.URL.wrap(this.properties).getString();
    }

    @Override
    public String serialization() {
        return BuiltInConnectionProperty.SERIALIZATION.wrap(this.properties).getString();
    }

    @Override
    public String authentication() {
        return BuiltInConnectionProperty.AUTHENTICATION.wrap(this.properties).getString();
    }

    @Override
    public String avaticaUser() {
        return BuiltInConnectionProperty.AVATICA_USER.wrap(this.properties).getString();
    }

    @Override
    public String avaticaPassword() {
        return BuiltInConnectionProperty.AVATICA_PASSWORD.wrap(this.properties).getString();
    }

    @Override
    public AvaticaHttpClientFactory httpClientFactory() {
        return BuiltInConnectionProperty.HTTP_CLIENT_FACTORY.wrap(this.properties).getPlugin(AvaticaHttpClientFactory.class, null);
    }

    @Override
    public String httpClientClass() {
        return BuiltInConnectionProperty.HTTP_CLIENT_IMPL.wrap(this.properties).getString();
    }

    @Override
    public String kerberosPrincipal() {
        return BuiltInConnectionProperty.PRINCIPAL.wrap(this.properties).getString();
    }

    @Override
    public File kerberosKeytab() {
        String keytabPath = BuiltInConnectionProperty.KEYTAB.wrap(this.properties).getString();
        if (null == keytabPath) {
            return null;
        }
        File keytab = new File(keytabPath);
        if (!keytab.exists() || !keytab.isFile()) {
            throw new RuntimeException("The " + BuiltInConnectionProperty.KEYTAB.name() + " does not  reference a normal, existent file: " + keytabPath);
        }
        return keytab;
    }

    @Override
    public File truststore() {
        String filename = BuiltInConnectionProperty.TRUSTSTORE.wrap(this.properties).getString();
        if (null == filename) {
            return null;
        }
        return new File(filename);
    }

    @Override
    public String truststorePassword() {
        return BuiltInConnectionProperty.TRUSTSTORE_PASSWORD.wrap(this.properties).getString();
    }

    @Override
    public File keystore() {
        String filename = BuiltInConnectionProperty.KEYSTORE.wrap(this.properties).getString();
        if (null == filename) {
            return null;
        }
        return new File(filename);
    }

    @Override
    public String keystorePassword() {
        return BuiltInConnectionProperty.KEYSTORE_PASSWORD.wrap(this.properties).getString();
    }

    @Override
    public String keyPassword() {
        return BuiltInConnectionProperty.KEY_PASSWORD.wrap(this.properties).getString();
    }

    @Override
    public HostnameVerificationConfigurable.HostnameVerification hostnameVerification() {
        return BuiltInConnectionProperty.HOSTNAME_VERIFICATION.wrap(this.properties).getEnum(HostnameVerificationConfigurable.HostnameVerification.class);
    }

    public static Map<ConnectionProperty, String> parse(Properties properties, Map<String, ? extends ConnectionProperty> nameToProps) {
        LinkedHashMap<ConnectionProperty, String> map = new LinkedHashMap<ConnectionProperty, String>();
        for (String name : properties.stringPropertyNames()) {
            ConnectionProperty connectionProperty = nameToProps.get(name.toUpperCase(Locale.ROOT));
            if (connectionProperty == null) continue;
            map.put(connectionProperty, properties.getProperty(name));
        }
        return map;
    }

    public static <E extends Enum> Converter<E> enumConverter(final Class<E> enumClass) {
        return new Converter<E>(){

            @Override
            public E apply(ConnectionProperty connectionProperty, String s2) {
                if (s2 == null) {
                    throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
                }
                try {
                    return Enum.valueOf(enumClass, s2);
                }
                catch (IllegalArgumentException e) {
                    for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                        if (!c.name().equalsIgnoreCase(s2)) continue;
                        return c;
                    }
                    throw new RuntimeException("Property '" + s2 + "' not valid for enum " + enumClass.getName());
                }
            }
        };
    }

    public static <T> Converter<T> pluginConverter(final Class<T> pluginClass, final T defaultInstance) {
        return new Converter<T>(){

            @Override
            public T apply(ConnectionProperty connectionProperty, String s2) {
                if (s2 == null) {
                    if (defaultInstance != null) {
                        return defaultInstance;
                    }
                    if (!connectionProperty.required()) {
                        return null;
                    }
                    throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
                }
                return AvaticaUtils.instantiatePlugin(pluginClass, s2);
            }
        };
    }

    static {
        MULTIPLIER_MAP.put("k", new BigDecimal(1024));
        MULTIPLIER_MAP.put("K", new BigDecimal(1024));
        MULTIPLIER_MAP.put("m", new BigDecimal(0x100000));
        MULTIPLIER_MAP.put("M", new BigDecimal(0x100000));
        MULTIPLIER_MAP.put("g", new BigDecimal(0x40000000));
        MULTIPLIER_MAP.put("G", new BigDecimal(0x40000000));
        NUMBER_CONVERTER = new Converter<Number>(){

            @Override
            public Number apply(ConnectionProperty connectionProperty, String s2) {
                if (s2 == null) {
                    throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
                }
                BigDecimal multiplier = BigDecimal.ONE;
                for (Map.Entry<String, BigDecimal> e : MULTIPLIER_MAP.entrySet()) {
                    if (!s2.endsWith(e.getKey())) continue;
                    multiplier = e.getValue();
                    s2 = s2.substring(0, s2.length() - e.getKey().length());
                }
                return new BigDecimal(s2).multiply(multiplier);
            }
        };
        IDENTITY_CONVERTER = new Converter<String>(){

            @Override
            public String apply(ConnectionProperty connectionProperty, String s2) {
                return s2;
            }
        };
    }

    public static interface Converter<T> {
        public T apply(ConnectionProperty var1, String var2);
    }

    public static class PropEnv {
        final Map<? extends ConnectionProperty, String> map;
        private final ConnectionProperty property;

        public PropEnv(Map<? extends ConnectionProperty, String> map, ConnectionProperty property) {
            this.map = map;
            this.property = property;
        }

        private <T> T get_(Converter<T> converter, String defaultValue) {
            String s2 = this.map.get(this.property);
            if (s2 != null) {
                return converter.apply(this.property, s2);
            }
            return converter.apply(this.property, defaultValue);
        }

        private <T> T getDefaultNull(Converter<T> converter) {
            String s2 = this.map.get(this.property);
            if (s2 != null) {
                return converter.apply(this.property, s2);
            }
            return null;
        }

        public String getString() {
            return this.getString((String)this.property.defaultValue());
        }

        public String getString(String defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.STRING);
            return this.get_(IDENTITY_CONVERTER, defaultValue);
        }

        public int getInt() {
            return this.getInt((Number)this.property.defaultValue());
        }

        public int getInt(Number defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.NUMBER);
            return this.get_(NUMBER_CONVERTER, defaultValue.toString()).intValue();
        }

        public long getLong() {
            return this.getLong((Number)this.property.defaultValue());
        }

        public long getLong(Number defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.NUMBER);
            return this.get_(NUMBER_CONVERTER, defaultValue.toString()).longValue();
        }

        public double getDouble() {
            return this.getDouble((Number)this.property.defaultValue());
        }

        public double getDouble(Number defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.NUMBER);
            return this.get_(NUMBER_CONVERTER, defaultValue.toString()).doubleValue();
        }

        public boolean getBoolean() {
            return this.getBoolean((Boolean)this.property.defaultValue());
        }

        public boolean getBoolean(boolean defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.BOOLEAN);
            return this.get_(BOOLEAN_CONVERTER, Boolean.toString(defaultValue));
        }

        public <E extends Enum<E>> E getEnum(Class<E> enumClass) {
            return (E)this.getEnum(enumClass, (Enum)this.property.defaultValue());
        }

        public <E extends Enum<E>> E getEnum(Class<E> enumClass, E defaultValue) {
            if (this.property.type() != ConnectionProperty.Type.ENUM) {
                throw new AssertionError((Object)"not an enum");
            }
            if (enumClass != this.property.valueClass()) {
                throw new AssertionError((Object)("wrong value class; expected " + this.property.valueClass()));
            }
            if (defaultValue == null) {
                return (E)((Enum)this.getDefaultNull(ConnectionConfigImpl.enumConverter(enumClass)));
            }
            return (E)((Enum)this.get_(ConnectionConfigImpl.enumConverter(enumClass), defaultValue.name()));
        }

        public <T> T getPlugin(Class<T> pluginClass, T defaultInstance) {
            return this.getPlugin(pluginClass, (String)this.property.defaultValue(), defaultInstance);
        }

        public <T> T getPlugin(Class<T> pluginClass, String defaultClassName, T defaultInstance) {
            assert (this.property.type() == ConnectionProperty.Type.PLUGIN);
            return this.get_(ConnectionConfigImpl.pluginConverter(pluginClass, defaultInstance), defaultClassName);
        }
    }
}

