/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.java;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.com.google.common.collect.ImmutableMultimap;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.hazelcast.org.apache.calcite.adapter.java.AbstractQueryableTable;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.schema.Function;
import com.hazelcast.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.org.apache.calcite.schema.Schema;
import com.hazelcast.org.apache.calcite.schema.SchemaFactory;
import com.hazelcast.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.org.apache.calcite.schema.Schemas;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.schema.Statistics;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.TableMacro;
import com.hazelcast.org.apache.calcite.schema.TranslatableTable;
import com.hazelcast.org.apache.calcite.schema.impl.AbstractSchema;
import com.hazelcast.org.apache.calcite.schema.impl.AbstractTableQueryable;
import com.hazelcast.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReflectiveSchema
extends AbstractSchema {
    private final Class clazz;
    private final Object target;
    private @MonotonicNonNull Map<String, Table> tableMap;
    private @MonotonicNonNull Multimap<String, Function> functionMap;

    public ReflectiveSchema(Object target) {
        this.clazz = target.getClass();
        this.target = target;
    }

    public String toString() {
        return "ReflectiveSchema(target=" + this.target + ")";
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            this.tableMap = this.createTableMap();
        }
        return this.tableMap;
    }

    private Map<String, Table> createTableMap() {
        ImmutableMap.Builder<String, Table> builder = ImmutableMap.builder();
        for (Field field : this.clazz.getFields()) {
            String fieldName = field.getName();
            Table table = this.fieldRelation(field);
            if (table == null) continue;
            builder.put(fieldName, table);
        }
        ImmutableMap<String, Table> tableMap = builder.build();
        for (Field field : this.clazz.getFields()) {
            RelReferentialConstraint rc;
            if (!RelReferentialConstraint.class.isAssignableFrom(field.getType())) continue;
            try {
                rc = (RelReferentialConstraint)field.get(this.target);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while accessing field " + field, e);
            }
            Objects.requireNonNull(rc, () -> "field must not be null: " + field);
            FieldTable table = (FieldTable)tableMap.get(Util.last(rc.getSourceQualifiedName()));
            assert (table != null);
            List<RelReferentialConstraint> referentialConstraints = table.getStatistic().getReferentialConstraints();
            if (referentialConstraints == null) {
                referentialConstraints = ImmutableList.of();
            }
            table.statistic = Statistics.of(ImmutableList.copyOf(Iterables.concat(referentialConstraints, Collections.singleton(rc))));
        }
        return tableMap;
    }

    @Override
    protected Multimap<String, Function> getFunctionMultimap() {
        if (this.functionMap == null) {
            this.functionMap = this.createFunctionMap();
        }
        return this.functionMap;
    }

    private Multimap<String, Function> createFunctionMap() {
        ImmutableMultimap.Builder<String, MethodTableMacro> builder = ImmutableMultimap.builder();
        for (Method method : this.clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class || methodName.equals("toString") || !TranslatableTable.class.isAssignableFrom(method.getReturnType())) continue;
            MethodTableMacro tableMacro = new MethodTableMacro(this, method);
            builder.put(methodName, tableMacro);
        }
        return builder.build();
    }

    Expression getTargetExpression(@Nullable SchemaPlus parentSchema, String name) {
        return EnumUtils.convert(Expressions.call(Schemas.unwrap(this.getExpression(parentSchema, name), ReflectiveSchema.class), BuiltInMethod.REFLECTIVE_SCHEMA_GET_TARGET.method, new Expression[0]), this.target.getClass());
    }

    private <T> @Nullable Table fieldRelation(Field field) {
        Object o;
        Type elementType = ReflectiveSchema.getElementType(field.getType());
        if (elementType == null) {
            return null;
        }
        try {
            o = field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while accessing field " + field, e);
        }
        Objects.requireNonNull(o, () -> "field " + field + " is null for " + this.target);
        Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
        return new FieldTable(field, elementType, enumerable);
    }

    private static @Nullable Type getElementType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    private static Enumerable toEnumerable(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return Linq4j.asEnumerable((Object[])o);
            }
            return Linq4j.asEnumerable(Primitive.asList(o));
        }
        if (o instanceof Iterable) {
            return Linq4j.asEnumerable((Iterable)o);
        }
        throw new RuntimeException("Cannot convert " + o.getClass() + " into a Enumerable");
    }

    private static class FieldSelector
    implements Function1<Object, Object[]> {
        private final Field[] fields;

        FieldSelector(Class elementType) {
            this.fields = elementType.getFields();
        }

        @Override
        public @Nullable Object[] apply(Object o) {
            try {
                @Nullable Object[] objects = new Object[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    objects[i] = this.fields[i].get(o);
                }
                return objects;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FieldTable<T>
    extends ReflectiveTable {
        private final Field field;
        private Statistic statistic;

        FieldTable(Field field, Type elementType, Enumerable<T> enumerable) {
            this(field, elementType, enumerable, Statistics.UNKNOWN);
        }

        FieldTable(Field field, Type elementType, Enumerable<T> enumerable, Statistic statistic) {
            super(elementType, enumerable);
            this.field = field;
            this.statistic = statistic;
        }

        public String toString() {
            return "Relation {field=" + this.field.getName() + "}";
        }

        @Override
        public Statistic getStatistic() {
            return this.statistic;
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            ReflectiveSchema reflectiveSchema = Objects.requireNonNull(schema.unwrap(ReflectiveSchema.class), () -> "schema.unwrap(ReflectiveSchema.class) for " + schema);
            return Expressions.field(reflectiveSchema.getTargetExpression(schema.getParentSchema(), schema.getName()), this.field);
        }
    }

    private static class MethodTableMacro
    extends ReflectiveFunctionBase
    implements TableMacro {
        private final ReflectiveSchema schema;

        MethodTableMacro(ReflectiveSchema schema, Method method) {
            super(method);
            this.schema = schema;
            assert (TranslatableTable.class.isAssignableFrom(method.getReturnType())) : "Method should return TranslatableTable so the macro can be expanded";
        }

        public String toString() {
            return "Member {method=" + this.method + "}";
        }

        @Override
        public TranslatableTable apply(List<? extends @Nullable Object> arguments) {
            try {
                Object o = Objects.requireNonNull(this.method.invoke(this.schema.getTarget(), arguments.toArray()), () -> "method " + this.method + " returned null for arguments " + arguments);
                return (TranslatableTable)o;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            Object target;
            Class<?> clazz;
            Object className = operand.get("class");
            if (className != null) {
                try {
                    clazz = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + className, e);
                }
            } else {
                throw new RuntimeException("Operand 'class' is required");
            }
            Object methodName = operand.get("staticMethod");
            if (methodName != null) {
                try {
                    Method method = clazz.getMethod((String)methodName, new Class[0]);
                    target = method.invoke(null, new Object[0]);
                    Objects.requireNonNull(target, () -> "method " + method + " returns null");
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking method " + methodName, e);
                }
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                target = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class " + className, e);
            }
            return new ReflectiveSchema(target);
        }
    }

    private static class ReflectiveTable
    extends AbstractQueryableTable
    implements Table,
    ScannableTable {
        private final Enumerable enumerable;

        ReflectiveTable(Type elementType, Enumerable enumerable) {
            super(elementType);
            this.enumerable = enumerable;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.elementType == Object[].class) {
                return this.enumerable;
            }
            return this.enumerable.select(new FieldSelector((Class)this.elementType));
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                @Override
                public Enumerator<T> enumerator() {
                    return enumerable.enumerator();
                }
            };
        }
    }
}

