/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.math;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastAbsFunction
extends HazelcastFunction {
    public static final HazelcastAbsFunction INSTANCE = new HazelcastAbsFunction();

    private HazelcastAbsFunction() {
        super("ABS", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        TypedOperandChecker checker;
        RelDataType operandType = binding.getOperandType(0);
        if (HazelcastTypeUtils.isNumericIntegerType(operandType)) {
            int bitWidth = ((HazelcastIntegerType)operandType).getBitWidth();
            operandType = HazelcastIntegerType.create(bitWidth + 1, operandType.isNullable());
        }
        if ((checker = TypedOperandChecker.forType(operandType)).isNumeric()) {
            return checker.check(binding, throwOnFailure, 0);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }
}

