/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBindingSignatureErrorAware;
import com.hazelcast.jet.sql.impl.validate.HazelcastResources;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collection;
import java.util.StringJoiner;

public class HazelcastCallBinding
extends SqlCallBinding {
    public HazelcastCallBinding(SqlCallBinding binding) {
        super(binding.getValidator(), binding.getScope(), binding.getCall());
    }

    @Override
    public HazelcastSqlValidator getValidator() {
        return (HazelcastSqlValidator)super.getValidator();
    }

    @Override
    public CalciteException newValidationSignatureError() {
        Resources.ExInst<SqlValidatorException> error;
        SqlOperator operator = this.getOperator();
        HazelcastSqlValidator validator = this.getValidator();
        SqlCall call = this.getCall();
        String operandTypes = HazelcastCallBinding.getOperandTypes(validator, call, this.getScope());
        String operatorName = '\'' + operator.getName() + '\'';
        switch (operator.getSyntax()) {
            case FUNCTION: 
            case FUNCTION_STAR: 
            case FUNCTION_ID: {
                error = HazelcastResources.RESOURCES.invalidFunctionOperands(operatorName, operandTypes);
                break;
            }
            default: {
                error = HazelcastResources.RESOURCES.invalidOperatorOperands(operatorName, operandTypes);
            }
        }
        return validator.newValidationError(call, error);
    }

    private static String getOperandTypes(SqlValidator validator, SqlCall call, SqlValidatorScope scope) {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        for (SqlNode operand : HazelcastCallBinding.getOperands(call)) {
            QueryDataType hazelcastType;
            RelDataType calciteType = validator.deriveType(scope, operand);
            String typeName = calciteType.getSqlTypeName() == SqlTypeName.NULL ? validator.getUnknownType().toString() : (calciteType.getSqlTypeName() == SqlTypeName.ROW || calciteType.getSqlTypeName() == SqlTypeName.COLUMN_LIST ? calciteType.getSqlTypeName().toString() : (calciteType.getSqlTypeName() == SqlTypeName.SYMBOL ? "SYMBOL" : (calciteType.getSqlTypeName() == SqlTypeName.CURSOR ? "CURSOR" : ((hazelcastType = HazelcastTypeUtils.toHazelcastType(calciteType)).getTypeFamily().getPublicType() != null ? hazelcastType.getTypeFamily().getPublicType().toString() : calciteType.getSqlTypeName().toString()))));
            res.add(typeName);
        }
        return res.toString();
    }

    private static Collection<SqlNode> getOperands(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof HazelcastCallBindingSignatureErrorAware) {
            return ((HazelcastCallBindingSignatureErrorAware)((Object)operator)).getOperandsForSignatureError(call);
        }
        return call.getOperandList();
    }
}

