/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapEvent;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.replicatedmap.impl.operation.GetOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.view.View;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class TablesStorage {
    private static final int MAX_CHECK_ATTEMPTS = 5;
    private static final long SLEEP_MILLIS = 100L;
    private static final String CATALOG_MAP_NAME = "__sql.catalog";
    private final NodeEngine nodeEngine;
    private final ILogger logger;

    public TablesStorage(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    void put(String name, Mapping mapping) {
        this.storage().put((Object)name, (Object)mapping);
        this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)mapping);
    }

    void put(String name, View view) {
        this.storage().put((Object)name, (Object)view);
        this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)view);
    }

    boolean putIfAbsent(String name, Mapping mapping) {
        Object previous = this.storage().putIfAbsent((Object)name, (Object)mapping);
        this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)mapping);
        return previous == null;
    }

    boolean putIfAbsent(String name, View view) {
        Object previous = this.storage().putIfAbsent((Object)name, (Object)view);
        this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)view);
        return previous == null;
    }

    Mapping removeMapping(String name) {
        return (Mapping)this.storage().remove((Object)name);
    }

    View getView(String name) {
        Object obj = this.storage().get((Object)name);
        if (obj instanceof View) {
            return (View)obj;
        }
        return null;
    }

    View removeView(String name) {
        return (View)this.storage().remove((Object)name);
    }

    Collection<Object> allObjects() {
        return this.storage().values();
    }

    Collection<String> mappingNames() {
        return this.storage().values().stream().filter(m4 -> m4 instanceof Mapping).map(m4 -> ((Mapping)m4).name()).collect(Collectors.toList());
    }

    Collection<String> viewNames() {
        return this.storage().values().stream().filter(v -> v instanceof View).map(v -> ((View)v).name()).collect(Collectors.toList());
    }

    void registerListener(EntryListener<String, Object> listener) {
        if (!this.nodeEngine.getLocalMember().isLiteMember()) {
            this.storage().addEntryListener(listener);
        }
    }

    private ReplicatedMap<String, Object> storage() {
        return this.nodeEngine.getHazelcastInstance().getReplicatedMap(CATALOG_MAP_NAME);
    }

    private Collection<Address> getMemberAddresses() {
        return this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).stream().filter(member -> !member.localMember() && !member.isLiteMember()).map(Member::getAddress).collect(Collectors.toSet());
    }

    private void awaitMappingOnAllMembers(String name, IdentifiedDataSerializable metadata) {
        Data keyData = this.nodeEngine.getSerializationService().toData((Object)name);
        int keyPartitionId = this.nodeEngine.getPartitionService().getPartitionId(keyData);
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<Address> memberAddresses = this.getMemberAddresses();
        for (int i = 0; i < 5 && !memberAddresses.isEmpty(); ++i) {
            List futures = memberAddresses.stream().map(memberAddress -> {
                Operation operation = new GetOperation(CATALOG_MAP_NAME, keyData).setPartitionId(keyPartitionId).setValidateTarget(false);
                return operationService.createInvocationBuilder("hz:impl:replicatedMapService", operation, memberAddress).setTryCount(1).invoke().toCompletableFuture().thenApply(result -> Objects.equals(metadata, result) ? memberAddress : null);
            }).collect(Collectors.toList());
            for (CompletableFuture future : futures) {
                try {
                    memberAddresses.remove(future.join());
                }
                catch (Exception e) {
                    this.logger.warning("Error occurred while trying to fetch mapping: " + e.getMessage(), (Throwable)e);
                }
            }
            if (memberAddresses.isEmpty()) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    static abstract class EntryListenerAdapter
    implements EntryListener<String, Object> {
        EntryListenerAdapter() {
        }

        public final void entryAdded(EntryEvent<String, Object> event) {
        }

        public abstract void entryUpdated(EntryEvent<String, Object> var1);

        public abstract void entryRemoved(EntryEvent<String, Object> var1);

        public final void entryEvicted(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be evicted - " + event);
        }

        public void entryExpired(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be expired - " + event);
        }

        public final void mapCleared(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be cleared - " + event);
        }

        public final void mapEvicted(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be evicted - " + event);
        }
    }
}

