/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.HazelcastSqlToRelConverter;
import com.hazelcast.jet.sql.impl.parse.QueryConverter;
import com.hazelcast.jet.sql.impl.parse.QueryParser;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelRoot;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.RelDecorrelator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.sql2rel.StandardConvertletTable;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.sql.impl.QueryException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class HazelcastViewExpander
implements RelOptTable.ViewExpander {
    private final QueryParser parser;
    private final RelOptCluster relOptCluster;
    private final SqlToRelConverter sqlToRelConverter;
    private final Deque<List<String>> expansionStack = new ArrayDeque<List<String>>();

    public HazelcastViewExpander(SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster relOptCluster) {
        this.parser = new QueryParser((HazelcastSqlValidator)validator);
        this.relOptCluster = relOptCluster;
        this.sqlToRelConverter = new HazelcastSqlToRelConverter((RelOptTable.ViewExpander)this, validator, catalogReader, relOptCluster, StandardConvertletTable.INSTANCE, QueryConverter.CONFIG);
    }

    @Override
    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
        if (this.expansionStack.contains(viewPath)) {
            throw QueryException.error((String)"Cycle detected in view references");
        }
        this.expansionStack.push(viewPath);
        SqlNode sqlNode = this.parser.parse(queryString).getNode();
        RelRoot root = this.sqlToRelConverter.convertQuery(sqlNode, true, true);
        this.expansionStack.pop();
        RelRoot root2 = root.withRel(this.sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = QueryConverter.CONFIG.getRelBuilderFactory().create(this.relOptCluster, null);
        return root2.withRel(RelDecorrelator.decorrelateQuery(root.rel, relBuilder));
    }
}

