/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlCreateJob
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE JOB", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;
    private final SqlNodeList options;
    private final SqlExtendedInsert sqlInsert;
    private final JobConfig jobConfig = new JobConfig();

    public SqlCreateJob(SqlIdentifier name, SqlNodeList options, SqlExtendedInsert sqlInsert, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
        this.sqlInsert = Objects.requireNonNull(sqlInsert, "A DML statement is mandatory");
        Preconditions.checkTrue((boolean)name.isSimple(), (String)name.toString());
        this.jobConfig.setName(name.toString());
    }

    public JobConfig jobConfig() {
        return this.jobConfig;
    }

    public SqlExtendedInsert dmlStatement() {
        return this.sqlInsert;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.options, this.sqlInsert);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE JOB");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("OPTIONS");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.options) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        this.sqlInsert.unparse(writer, leftPrec, rightPrec);
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print(" ");
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace()) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.notSupported("OR REPLACE", "CREATE JOB"));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option0 : this.options.getList()) {
            SqlOption option = (SqlOption)option0;
            String key = option.keyString();
            String value = option.valueString();
            if (!optionNames.add(key)) {
                throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(key));
            }
            block11 : switch (key) {
                case "processingGuarantee": {
                    switch (value) {
                        case "exactlyOnce": {
                            this.jobConfig.setProcessingGuarantee(ProcessingGuarantee.EXACTLY_ONCE);
                            break block11;
                        }
                        case "atLeastOnce": {
                            this.jobConfig.setProcessingGuarantee(ProcessingGuarantee.AT_LEAST_ONCE);
                            break block11;
                        }
                        case "none": {
                            this.jobConfig.setProcessingGuarantee(ProcessingGuarantee.NONE);
                            break block11;
                        }
                    }
                    throw validator.newValidationError(option.value(), ParserResource.RESOURCE.processingGuaranteeBadValue(key, value));
                }
                case "snapshotIntervalMillis": {
                    try {
                        this.jobConfig.setSnapshotIntervalMillis(Long.parseLong(value));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw validator.newValidationError(option.value(), ParserResource.RESOURCE.jobOptionIncorrectNumber(key, value));
                    }
                }
                case "autoScaling": {
                    this.jobConfig.setAutoScaling(Boolean.parseBoolean(value));
                    break;
                }
                case "splitBrainProtectionEnabled": {
                    this.jobConfig.setSplitBrainProtection(Boolean.parseBoolean(value));
                    break;
                }
                case "metricsEnabled": {
                    this.jobConfig.setMetricsEnabled(Boolean.parseBoolean(value));
                    break;
                }
                case "storeMetricsAfterJobCompletion": {
                    this.jobConfig.setStoreMetricsAfterJobCompletion(Boolean.parseBoolean(value));
                    break;
                }
                case "initialSnapshotName": {
                    this.jobConfig.setInitialSnapshotName(value);
                    break;
                }
                case "maxProcessorAccumulatedRecords": {
                    this.jobConfig.setMaxProcessorAccumulatedRecords(Long.parseLong(value));
                    break;
                }
                default: {
                    throw validator.newValidationError(option.key(), ParserResource.RESOURCE.unknownJobOption(key));
                }
            }
        }
        validator.validate(this.sqlInsert);
    }
}

