/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.sql.impl.QueryException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlCreateIndex
extends SqlCreate {
    public static final String UNIQUE_KEY = "unique_key";
    public static final String UNIQUE_KEY_TRANSFORMATION = "unique_key_transformation";
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE INDEX", SqlKind.CREATE_INDEX);
    private final SqlIdentifier name;
    private final SqlIdentifier mapName;
    private final SqlNodeList columns;
    private final SqlIdentifier type;
    private final SqlNodeList options;

    public SqlCreateIndex(SqlIdentifier name, SqlIdentifier mapName, SqlNodeList columns, SqlIdentifier type, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.mapName = Objects.requireNonNull(mapName, "Map name should not be null");
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.type = type;
        this.options = Objects.requireNonNull(options, "Options should not be null");
    }

    public List<String> columns() {
        return Util.toList((Collection)this.columns, n -> ((SqlIdentifier)n).getSimple());
    }

    public IndexType type() {
        return this.getIndexType();
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public String mapName() {
        return this.mapName.toString();
    }

    public String indexName() {
        return this.name.toString();
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columns, this.type, this.options);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE INDEX");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("ON");
        this.mapName.unparse(writer, leftPrec, rightPrec);
        if (this.columns.size() > 0) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                SqlCreateIndex.printIndent(writer);
                column.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        writer.newlineAndIndent();
        writer.keyword("TYPE");
        this.type.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("OPTIONS");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.options) {
                SqlCreateIndex.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private static void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace()) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.notSupported("OR REPLACE", "CREATE INDEX"));
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (SqlNode column : this.columns.getList()) {
            String name = ((SqlIdentifier)Objects.requireNonNull(column)).getSimple();
            if (columnNames.add(name)) continue;
            throw validator.newValidationError(column, ParserResource.RESOURCE.duplicateIndexAttribute(name));
        }
        IndexType indexType = this.getIndexType();
        if (!indexType.equals((Object)IndexType.BITMAP) && !this.options.getList().isEmpty()) {
            throw validator.newValidationError(this.options, ParserResource.RESOURCE.unsupportedIndexType(indexType.name(), this.options().keySet().iterator().next()));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option : this.options.getList()) {
            String name = ((SqlOption)option).keyString();
            if (optionNames.add(name)) continue;
            throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(name));
        }
    }

    @Nonnull
    private IndexType getIndexType() {
        IndexType type;
        String indexType;
        if (this.type == null) {
            return IndexConfig.DEFAULT_TYPE;
        }
        switch (indexType = this.type.toString().toLowerCase()) {
            case "sorted": {
                type = IndexType.SORTED;
                break;
            }
            case "hash": {
                type = IndexType.HASH;
                break;
            }
            case "bitmap": {
                type = IndexType.BITMAP;
                break;
            }
            default: {
                throw QueryException.error((String)"Can't create index: wrong index type. Only HASH, SORTED and BITMAP types are supported.");
            }
        }
        return type;
    }
}

