/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.CalciteConfiguration;
import com.hazelcast.jet.sql.impl.calcite.parser.HazelcastSqlParser;
import com.hazelcast.jet.sql.impl.parse.QueryParseResult;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlConformance;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.UnsupportedOperationVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.org.apache.calcite.sql.parser.impl.ParseException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryParameterMetadata;

public class QueryParser {
    private static final SqlParser.Config CONFIG;
    private final HazelcastSqlValidator validator;

    public QueryParser(HazelcastSqlValidator validator) {
        this.validator = validator;
    }

    public QueryParseResult parse(String sql) {
        try {
            return this.parse0(sql);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e instanceof SqlParseException && e.getCause() instanceof ParseException ? QueryParser.trimMessage(e.getMessage()) : e.getMessage();
            throw QueryException.error((int)1008, (String)message, (Throwable)e);
        }
    }

    private QueryParseResult parse0(String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create(sql, CONFIG);
        SqlNodeList statements = parser.parseStmtList();
        if (statements.size() != 1) {
            throw QueryException.error((int)1008, (String)"The command must contain a single statement");
        }
        SqlNode topNode = statements.get(0);
        SqlNode node = this.validator.validate(topNode);
        UnsupportedOperationVisitor visitor = new UnsupportedOperationVisitor();
        node.accept(visitor);
        return new QueryParseResult(node, new QueryParameterMetadata(this.validator.getParameterConverters(node)), this.validator.isInfiniteRows());
    }

    private static String trimMessage(String message) {
        String eol = System.getProperty("line.separator", "\n");
        String[] parts = message.split(eol, 2);
        return parts[0];
    }

    static {
        SqlParser.ConfigBuilder configBuilder = SqlParser.configBuilder();
        CalciteConfiguration.DEFAULT.toParserConfig(configBuilder);
        configBuilder.setConformance(HazelcastSqlConformance.INSTANCE);
        configBuilder.setParserFactory(HazelcastSqlParser.FACTORY);
        CONFIG = configBuilder.build();
    }
}

