/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.HazelcastSqlToRelConverter;
import com.hazelcast.jet.sql.impl.parse.QueryConvertResult;
import com.hazelcast.jet.sql.impl.schema.HazelcastViewExpander;
import com.hazelcast.org.apache.calcite.plan.Contexts;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCostImpl;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelRoot;
import com.hazelcast.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalFilter;
import com.hazelcast.org.apache.calcite.rel.rules.CoreRules;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.sql2rel.StandardConvertletTable;
import com.hazelcast.org.apache.calcite.util.Pair;
import javax.annotation.Nullable;

public class QueryConverter {
    public static final SqlToRelConverter.Config CONFIG = SqlToRelConverter.config().withExpand(false).withInSubQueryThreshold(10000).withTrimUnusedFields(true);
    private static final boolean EXPAND = false;
    private static final boolean TRIM_UNUSED_FIELDS = true;
    private static final int HAZELCAST_IN_ELEMENTS_THRESHOLD = 10000;
    private final SqlValidator validator;
    private final Prepare.CatalogReader catalogReader;
    private final RelOptCluster cluster;
    private final HazelcastViewExpander viewExpander;

    public QueryConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, HazelcastRelOptCluster cluster) {
        this.validator = validator;
        this.catalogReader = catalogReader;
        this.cluster = cluster;
        this.viewExpander = new HazelcastViewExpander(validator, catalogReader, cluster);
    }

    public QueryConvertResult convert(SqlNode node) {
        HazelcastSqlToRelConverter converter = new HazelcastSqlToRelConverter((RelOptTable.ViewExpander)this.viewExpander, this.validator, this.catalogReader, this.cluster, StandardConvertletTable.INSTANCE, CONFIG);
        RelRoot root = converter.convertQuery(node, false, true);
        RelNode relNoSubqueries = QueryConverter.rewriteSubqueries(root.project());
        RelNode result = converter.decorrelate(node, relNoSubqueries);
        if (!QueryConverter.hasNestedExists(root.rel)) {
            result = converter.trimUnusedFields(true, result);
        }
        return new QueryConvertResult(result, Pair.right(root.fields));
    }

    private static RelNode rewriteSubqueries(RelNode rel) {
        HepProgramBuilder hepProgramBuilder = new HepProgramBuilder();
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.JOIN_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.UNION_MERGE);
        hepProgramBuilder.addRuleInstance(CoreRules.UNION_TO_DISTINCT);
        HepPlanner planner = new HepPlanner(hepProgramBuilder.build(), Contexts.empty(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(rel);
        return planner.findBestExp();
    }

    private static boolean hasNestedExists(RelNode root) {
        class NestedExistsFinder
        extends RelVisitor {
            private boolean found;
            private int depth;
            final /* synthetic */ RelNode val$root;

            NestedExistsFinder(RelNode relNode) {
                this.val$root = relNode;
            }

            @Override
            public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                RexSubQuery exists;
                if (node instanceof LogicalFilter && (exists = this.getExists((LogicalFilter)node)) != null) {
                    this.found |= this.depth > 0;
                    ++this.depth;
                    this.go(exists.rel);
                    --this.depth;
                }
                super.visit(node, ordinal, parent);
            }

            private boolean find() {
                this.go(this.val$root);
                return this.found;
            }

            private RexSubQuery getExists(LogicalFilter filter) {
                final RexSubQuery[] existsSubQuery = new RexSubQuery[]{null};
                filter.getCondition().accept(new RexVisitorImpl<Void>(true){

                    @Override
                    public Void visitSubQuery(RexSubQuery subQuery) {
                        if (subQuery.getKind() == SqlKind.EXISTS) {
                            existsSubQuery[0] = subQuery;
                        }
                        return (Void)super.visitSubQuery(subQuery);
                    }
                });
                return existsSubQuery[0];
            }
        }
        return new NestedExistsFinder(root).find();
    }
}

