/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.AggregateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ProjectLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SlidingWindowLogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAbstractPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.ProjectPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class AggregateSlidingWindowPhysicalRule
extends AggregateAbstractPhysicalRule {
    private static final RelRule.Config CONFIG_PROJECT = RelRule.Config.EMPTY.withDescription(AggregateSlidingWindowPhysicalRule.class.getSimpleName() + "-project").withOperandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isUnbounded).inputs(b1 -> b1.operand(ProjectLogicalRel.class).inputs(b2 -> b2.operand(SlidingWindowLogicalRel.class).anyInputs())));
    private static final RelRule.Config CONFIG_NO_PROJECT = RelRule.Config.EMPTY.withDescription(AggregateSlidingWindowPhysicalRule.class.getSimpleName() + "-no-project").withOperandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isUnbounded).inputs(b1 -> b1.operand(SlidingWindowLogicalRel.class).anyInputs()));
    static final RelOptRule NO_PROJECT_INSTANCE = new AggregateSlidingWindowPhysicalRule(CONFIG_NO_PROJECT, false);
    static final RelOptRule PROJECT_INSTANCE = new AggregateSlidingWindowPhysicalRule(CONFIG_PROJECT, true);
    private final boolean hasProject;

    private AggregateSlidingWindowPhysicalRule(RelRule.Config config, boolean hasProject) {
        super(config);
        this.hasProject = hasProject;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SlidingWindowLogicalRel windowRel;
        RelDataType projectRowType;
        ArrayList<RexNode> projections;
        AggregateLogicalRel logicalAggregate = (AggregateLogicalRel)call.rel(0);
        assert (logicalAggregate.getGroupType() == Aggregate.Group.SIMPLE);
        assert (logicalAggregate.getGroupSets().size() == 1 && (logicalAggregate.getGroupSet() == null || logicalAggregate.getGroupSet().equals(logicalAggregate.getGroupSets().get(0))));
        if (this.hasProject) {
            Project projectRel = (Project)call.rel(1);
            projections = new ArrayList<RexNode>(projectRel.getProjects());
            projectRowType = projectRel.getRowType();
            windowRel = (SlidingWindowLogicalRel)call.rel(2);
        } else {
            windowRel = (SlidingWindowLogicalRel)call.rel(1);
            List<RelDataTypeField> fields = windowRel.getRowType().getFieldList();
            projections = new ArrayList(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                RelDataTypeField field = fields.get(i);
                projections.add(call.builder().getRexBuilder().makeInputRef(field.getType(), i));
            }
            projectRowType = windowRel.getRowType();
        }
        int timestampIndex = windowRel.orderingFieldIndex();
        int windowStartIndex = windowRel.windowStartIndex();
        int windowEndIndex = windowRel.windowEndIndex();
        ArrayList<Integer> windowStartIndexes = new ArrayList<Integer>();
        ArrayList<Integer> windowEndIndexes = new ArrayList<Integer>();
        for (int i = 0; i < projections.size(); ++i) {
            RexNode projection = (RexNode)projections.get(i);
            if (projection instanceof RexInputRef) {
                int index = ((RexInputRef)projection).getIndex();
                if (index != windowStartIndex && index != windowEndIndex) continue;
                projection = call.builder().getRexBuilder().makeInputRef(projection.getType(), timestampIndex);
                projections.set(i, projection);
                if (index == windowStartIndex) {
                    windowStartIndexes.add(i);
                    continue;
                }
                windowEndIndexes.add(i);
                continue;
            }
            if (!OptUtils.hasInputRef(projection, windowStartIndex, windowEndIndex)) continue;
            throw QueryException.error((int)1008, (String)"In window aggregation, the window_start and window_end fields must be used directly, without any transformation");
        }
        RelNode input = windowRel.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            RelDataType newRowType = projectRowType;
            ProjectPhysicalRel newProject = new ProjectPhysicalRel(transformedInput.getCluster(), transformedInput.getTraitSet(), transformedInput, projections, newRowType);
            RelNode transformedRel = this.transform(newProject, logicalAggregate, windowStartIndexes, windowEndIndexes, windowRel.windowPolicyProvider());
            if (transformedRel == null) continue;
            call.transformTo(transformedRel);
        }
    }

    private RelNode transform(RelNode physicalInput, AggregateLogicalRel logicalAggregate, List<Integer> windowStartIndexes, List<Integer> windowEndIndexes, FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider) {
        Integer watermarkedField = AggregateSlidingWindowPhysicalRule.findWatermarkedField(logicalAggregate, physicalInput);
        if (watermarkedField == null) {
            return null;
        }
        RexInputRef timestampExpression = logicalAggregate.getCluster().getRexBuilder().makeInputRef(physicalInput, (int)watermarkedField);
        return new SlidingWindowAggregatePhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), timestampExpression, windowPolicyProvider, logicalAggregate.containsDistinctCall() ? 1 : 2, windowStartIndexes, windowEndIndexes);
    }

    @Nullable
    private static Integer findWatermarkedField(AggregateLogicalRel logicalAggregate, RelNode input) {
        HazelcastRelMetadataQuery query = OptUtils.metadataQuery(input);
        WatermarkedFields watermarkedFields = query.extractWatermarkedFields(input);
        if (watermarkedFields == null) {
            return null;
        }
        Map.Entry<Integer, RexNode> watermarkedField = watermarkedFields.findFirst(logicalAggregate.getGroupSet());
        return watermarkedField != null ? watermarkedField.getKey() : null;
    }
}

