/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.metadata;

import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.jet.sql.impl.opt.logical.WatermarkLogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.plan.hep.HepRelVertex;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Util;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class HazelcastRelMdWatermarkedFields
implements MetadataHandler<WatermarkedFieldsMetadata> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(WatermarkedFieldsMetadata.METHOD, new HazelcastRelMdWatermarkedFields());

    private HazelcastRelMdWatermarkedFields() {
    }

    @Override
    public MetadataDef<WatermarkedFieldsMetadata> getDef() {
        return WatermarkedFieldsMetadata.DEF;
    }

    public WatermarkedFields extractWatermarkedFields(FullScan rel, RelMetadataQuery mq) {
        return HazelcastRelMdWatermarkedFields.watermarkedFieldByIndex(rel, rel.watermarkedColumnIndex());
    }

    public WatermarkedFields extractWatermarkedFields(WatermarkLogicalRel rel) {
        return HazelcastRelMdWatermarkedFields.watermarkedFieldByIndex(rel, rel.watermarkedColumnIndex());
    }

    private static WatermarkedFields watermarkedFieldByIndex(RelNode rel, int watermarkedFieldIndex) {
        if (watermarkedFieldIndex < 0) {
            return null;
        }
        return new WatermarkedFields(ImmutableMap.of(watermarkedFieldIndex, rel.getCluster().getRexBuilder().makeInputRef(rel, watermarkedFieldIndex)));
    }

    public WatermarkedFields extractWatermarkedFields(SlidingWindow rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        WatermarkedFields inputWatermarkedFields = query.extractWatermarkedFields(rel.getInput());
        if (inputWatermarkedFields == null || !inputWatermarkedFields.getPropertiesByIndex().containsKey(rel.orderingFieldIndex())) {
            return inputWatermarkedFields;
        }
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        return inputWatermarkedFields.merge(new WatermarkedFields(ImmutableMap.of(rel.windowStartIndex(), rexBuilder.makeInputRef(rel, rel.windowStartIndex()), rel.windowEndIndex(), rexBuilder.makeInputRef(rel, rel.windowEndIndex()))));
    }

    public WatermarkedFields extractWatermarkedFields(Project rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        WatermarkedFields inputWmFields = query.extractWatermarkedFields(rel.getInput());
        if (inputWmFields == null) {
            return null;
        }
        HashMap<Integer, RexNode> outputWmFields = new HashMap<Integer, RexNode>();
        for (int i = 0; i < rel.getProjects().size(); ++i) {
            RexNode project = rel.getProjects().get(i);
            RexNode project2 = ValidationUtil.unwrapAsOperatorOperand(project);
            if (!(project2 instanceof RexInputRef)) continue;
            int index = ((RexInputRef)project2).getIndex();
            if (!inputWmFields.getPropertiesByIndex().containsKey(index)) continue;
            outputWmFields.put(i, project);
        }
        return new WatermarkedFields(outputWmFields);
    }

    public WatermarkedFields extractWatermarkedFields(Filter rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractWatermarkedFields(rel.getInput());
    }

    public WatermarkedFields extractWatermarkedFields(SlidingWindowAggregatePhysicalRel rel, RelMetadataQuery mq) {
        return rel.watermarkedFields();
    }

    public WatermarkedFields extractWatermarkedFields(Aggregate rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        WatermarkedFields inputWmFields = query.extractWatermarkedFields(rel.getInput());
        if (inputWmFields == null || rel.getGroupSets().size() != 1) {
            return null;
        }
        Iterator<Integer> groupedIndexes = ((ImmutableBitSet)rel.getGroupSets().get(0)).iterator();
        HashMap<Integer, RexNode> outputProperties = new HashMap<Integer, RexNode>();
        int outputIndex = 0;
        while (groupedIndexes.hasNext()) {
            int groupedBy = groupedIndexes.next();
            if (inputWmFields.getPropertiesByIndex().containsKey(groupedBy)) {
                outputProperties.put(outputIndex, rel.getCluster().getRexBuilder().makeInputRef(rel, outputIndex));
            }
            ++outputIndex;
        }
        return new WatermarkedFields(outputProperties);
    }

    public WatermarkedFields extractWatermarkedFields(Join rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractWatermarkedFields(rel.getLeft());
    }

    public WatermarkedFields extractWatermarkedFields(RelSubset subset, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        RelNode rel = Util.first(subset.getBest(), subset.getOriginal());
        return query.extractWatermarkedFields(rel);
    }

    public WatermarkedFields extractWatermarkedFields(HepRelVertex vertex, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        RelNode rel = vertex.getCurrentRel();
        return query.extractWatermarkedFields(rel);
    }

    public WatermarkedFields extractWatermarkedFields(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public static interface WatermarkedFieldsMetadata
    extends Metadata {
        public static final Method METHOD = Types.lookupMethod(WatermarkedFieldsMetadata.class, "extractWatermarkedFields", new Class[0]);
        public static final MetadataDef<WatermarkedFieldsMetadata> DEF = MetadataDef.of(WatermarkedFieldsMetadata.class, Handler.class, METHOD);

        public WatermarkedFields extractWatermarkedFields();

        public static interface Handler
        extends MetadataHandler<WatermarkedFieldsMetadata> {
            public WatermarkedFields extractWatermarkedFields(RelNode var1, RelMetadataQuery var2);
        }
    }
}

