/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.ExpressionValues;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FilterLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ProjectLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UnionLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.Union;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalValues;
import java.util.ArrayList;
import java.util.Collections;

final class ValuesLogicalRules {
    static final RelOptRuleOperand VALUES_CHILD_OPERAND = RelOptRule.operand(ValuesLogicalRel.class, RelOptRule.none());
    static final RelOptRule CONVERT_INSTANCE = new ConverterRule(LogicalValues.class, (RelTrait)Convention.NONE, (RelTrait)Conventions.LOGICAL, ValuesLogicalRules.class.getSimpleName() + "(Convert)"){

        @Override
        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            ExpressionValues.SimpleExpressionValues expressionValues = new ExpressionValues.SimpleExpressionValues(values.getTuples());
            return new ValuesLogicalRel(values.getCluster(), OptUtils.toLogicalConvention(values.getTraitSet()), values.getRowType(), Collections.singletonList(expressionValues));
        }
    };
    static final RelOptRule FILTER_INSTANCE = new RelOptRule(RelOptRule.operand(FilterLogicalRel.class, RelOptRule.some(RelOptRule.operand(ValuesLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0])), ValuesLogicalRules.class.getSimpleName() + "(Filter)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            ValuesLogicalRel values = (ValuesLogicalRel)call.rel(1);
            ExpressionValues.TransformedExpressionValues expressionValues = new ExpressionValues.TransformedExpressionValues(filter.getCondition(), null, values.getRowType(), values.values(), ((HazelcastRelOptCluster)filter.getCluster()).getParameterMetadata());
            ValuesLogicalRel rel = new ValuesLogicalRel(filter.getCluster(), filter.getTraitSet(), filter.getRowType(), Collections.singletonList(expressionValues));
            call.transformTo(rel);
        }
    };
    static final RelOptRule PROJECT_INSTANCE = new RelOptRule(RelOptRule.operand(ProjectLogicalRel.class, RelOptRule.some(RelOptRule.operand(ValuesLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0])), ValuesLogicalRules.class.getSimpleName() + "(Project)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            ValuesLogicalRel values = (ValuesLogicalRel)call.rel(1);
            ExpressionValues.TransformedExpressionValues expressionValues = new ExpressionValues.TransformedExpressionValues(null, project.getProjects(), values.getRowType(), values.values(), ((HazelcastRelOptCluster)project.getCluster()).getParameterMetadata());
            ValuesLogicalRel rel = new ValuesLogicalRel(project.getCluster(), project.getTraitSet(), project.getRowType(), Collections.singletonList(expressionValues));
            call.transformTo(rel);
        }
    };
    static final RelOptRule PROJECT_FILTER_INSTANCE = new RelOptRule(RelOptRule.operand(ProjectLogicalRel.class, RelOptRule.some(RelOptRule.operand(FilterLogicalRel.class, RelOptRule.operand(ValuesLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])), ValuesLogicalRules.class.getSimpleName() + "(Project-Filter)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            ValuesLogicalRel values = (ValuesLogicalRel)call.rel(2);
            ExpressionValues.TransformedExpressionValues expressionValues = new ExpressionValues.TransformedExpressionValues(filter.getCondition(), project.getProjects(), values.getRowType(), values.values(), ((HazelcastRelOptCluster)project.getCluster()).getParameterMetadata());
            ValuesLogicalRel rel = new ValuesLogicalRel(project.getCluster(), project.getTraitSet(), project.getRowType(), Collections.singletonList(expressionValues));
            call.transformTo(rel);
        }
    };
    static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(UnionLogicalRel.class, RelOptRule.unordered(VALUES_CHILD_OPERAND, new RelOptRuleOperand[0])), ValuesLogicalRules.class.getSimpleName() + "(Union)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Union union = (Union)call.rel(0);
            ArrayList<ExpressionValues> expressionValues = new ArrayList<ExpressionValues>(union.getInputs().size());
            for (RelNode input : union.getInputs()) {
                ValuesLogicalRel values = (ValuesLogicalRel)OptUtils.findMatchingRel(input, VALUES_CHILD_OPERAND);
                if (values == null) {
                    return;
                }
                expressionValues.addAll(values.values());
            }
            ValuesLogicalRel rel = new ValuesLogicalRel(union.getCluster(), union.getTraitSet(), union.getRowType(), expressionValues);
            call.transformTo(rel);
        }
    };

    private ValuesLogicalRules() {
    }
}

