/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import java.util.List;

public final class ProjectIntoScanLogicalRule
extends RelOptRule {
    public static final ProjectIntoScanLogicalRule INSTANCE = new ProjectIntoScanLogicalRule();

    private ProjectIntoScanLogicalRule() {
        super(ProjectIntoScanLogicalRule.operand(Project.class, ProjectIntoScanLogicalRule.operand(FullScanLogicalRel.class, ProjectIntoScanLogicalRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ProjectIntoScanLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        FullScanLogicalRel scan = (FullScanLogicalRel)call.rel(1);
        HazelcastTable originalTable = OptUtils.extractHazelcastTable(scan);
        List<RexNode> newProjects = OptUtils.inlineExpressions(originalTable.getProjects(), project.getProjects());
        HazelcastRelOptTable convertedTable = OptUtils.createRelTable((HazelcastRelOptTable)scan.getTable(), originalTable.withProject(newProjects, project.getRowType()), scan.getCluster().getTypeFactory());
        FullScanLogicalRel rel = new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, scan.eventTimePolicyProvider(), scan.watermarkedColumnIndex());
        call.transformTo(rel);
    }
}

