/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.Projector;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class UpdatingEntryProcessor
implements EntryProcessor<Object, Object, Long>,
SerializationServiceAware,
DataSerializable {
    private KvRowProjector.Supplier rowProjectorSupplier;
    private Projector.Supplier valueProjectorSupplier;
    private List<Object> arguments;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private UpdatingEntryProcessor() {
    }

    private UpdatingEntryProcessor(KvRowProjector.Supplier rowProjectorSupplier, Projector.Supplier valueProjectorSupplier, List<Object> arguments) {
        this.rowProjectorSupplier = rowProjectorSupplier;
        this.valueProjectorSupplier = valueProjectorSupplier;
        this.arguments = arguments;
    }

    public Long process(Map.Entry<Object, Object> entry) {
        if (entry.getValue() == null) {
            return 0L;
        }
        JetSqlRow row = this.rowProjectorSupplier.get(this.evalContext, this.extractors).project(entry.getKey(), entry.getValue());
        Object value = this.valueProjectorSupplier.get(this.evalContext).project(row);
        if (value == null) {
            throw QueryException.error((String)"Cannot assign null to value");
        }
        entry.setValue(value);
        return 1L;
    }

    public void setSerializationService(SerializationService serializationService) {
        this.evalContext = new ExpressionEvalContext(this.arguments, (InternalSerializationService)serializationService);
        this.extractors = Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.rowProjectorSupplier);
        out.writeObject((Object)this.valueProjectorSupplier);
        out.writeObject(this.arguments);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.rowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
        this.valueProjectorSupplier = (Projector.Supplier)in.readObject();
        this.arguments = (List)in.readObject();
    }

    public static Supplier supplier(PartitionedMapTable table, Map<String, Expression<?>> updatesByFieldNames) {
        table.keyFields().filter(field -> updatesByFieldNames.containsKey(field.getName())).findFirst().ifPresent(field -> {
            throw QueryException.error((String)("Cannot update '" + field.getName() + '\''));
        });
        if (updatesByFieldNames.containsKey(QueryPath.VALUE) && table.valueFields().count() > 1L) {
            throw QueryException.error((String)("Cannot update '" + QueryPath.VALUE + '\''));
        }
        List<Expression<?>> projections = IntStream.range(0, table.getFieldCount()).mapToObj(i -> ColumnExpression.create((int)i, (QueryDataType)table.getField(i).getType())).collect(Collectors.toList());
        KvRowProjector.Supplier rowProjectorSupplier = KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), null, projections);
        List<Expression<?>> updates = IntStream.range(0, table.getFieldCount()).filter(i -> !((MapTableField)table.getField(i)).getPath().isKey()).mapToObj(i -> {
            TableField field = table.getField(i);
            if (updatesByFieldNames.containsKey(field.getName())) {
                return (Expression)updatesByFieldNames.get(field.getName());
            }
            if (field.getName().equals(QueryPath.VALUE)) {
                return ConstantExpression.create(null, (QueryDataType)field.getType());
            }
            return ColumnExpression.create((int)i, (QueryDataType)field.getType());
        }).collect(Collectors.toList());
        Projector.Supplier valueProjectorSupplier = Projector.supplier(table.valuePaths(), table.valueTypes(), (UpsertTargetDescriptor)table.getValueJetMetadata(), updates);
        return new Supplier(rowProjectorSupplier, valueProjectorSupplier);
    }

    public static final class Supplier
    implements DataSerializable {
        private KvRowProjector.Supplier rowProjectorSupplier;
        private Projector.Supplier valueProjectorSupplier;

        private Supplier() {
        }

        private Supplier(KvRowProjector.Supplier rowProjectorSupplier, Projector.Supplier valueProjectorSupplier) {
            this.rowProjectorSupplier = rowProjectorSupplier;
            this.valueProjectorSupplier = valueProjectorSupplier;
        }

        public EntryProcessor<Object, Object, Long> get(List<Object> arguments) {
            return new UpdatingEntryProcessor(this.rowProjectorSupplier, this.valueProjectorSupplier, arguments);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.rowProjectorSupplier);
            out.writeObject((Object)this.valueProjectorSupplier);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.rowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
            this.valueProjectorSupplier = (Projector.Supplier)in.readObject();
        }
    }
}

