/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.impl.processor.TransformP;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public final class RowProjectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private KvRowProjector.Supplier projectorSupplier;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private RowProjectorProcessorSupplier() {
    }

    public RowProjectorProcessorSupplier(KvRowProjector.Supplier projectorSupplier) {
        this.projectorSupplier = projectorSupplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        this.extractors = Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build();
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<TransformP> processors = new ArrayList<TransformP>(count);
        for (int i = 0; i < count; ++i) {
            ResettableSingletonTraverser traverser = new ResettableSingletonTraverser();
            KvRowProjector projector = this.projectorSupplier.get(this.evalContext, this.extractors);
            TransformP processor = new TransformP((FunctionEx & Serializable)entry -> {
                traverser.accept((Object)projector.project(entry.getKeyData(), entry.getValueData()));
                return traverser;
            });
            processors.add(processor);
        }
        return processors;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.projectorSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.projectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }

    public static ProcessorSupplier rowProjector(QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projection) {
        return new RowProjectorProcessorSupplier(KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projection));
    }
}

