/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.map.Metadata;
import com.hazelcast.jet.sql.impl.connector.map.SampleMetadataResolver;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.Mapping;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class MetadataResolver
implements IMapResolver {
    private final NodeEngine nodeEngine;

    public MetadataResolver(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Nullable
    public Mapping resolve(String iMapName) {
        MapService service = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        MapContainer container = context.getExistingMapContainer(iMapName);
        if (container == null) {
            return null;
        }
        boolean hd = container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        Metadata metadata = hd ? this.resolveFromHd(container) : this.resolveFromHeap(iMapName, context);
        return metadata == null ? null : new Mapping(iMapName, iMapName, "IMap", metadata.fields(), metadata.options());
    }

    @Nullable
    private Metadata resolveFromHd(MapContainer container) {
        if (container.getIndexes() == null) {
            return null;
        }
        InternalIndex[] indexes = container.getIndexes().getIndexes();
        if (indexes == null || indexes.length == 0) {
            return null;
        }
        InternalIndex index = indexes[0];
        Iterator entryIterator = index.getSqlRecordIterator(false);
        if (!entryIterator.hasNext()) {
            return null;
        }
        QueryableEntry entry = (QueryableEntry)entryIterator.next();
        return this.resolveMetadata(entry.getKey(), entry.getValue());
    }

    @Nullable
    private Metadata resolveFromHeap(String name, MapServiceContext context) {
        for (PartitionContainer partitionContainer : context.getPartitionContainers()) {
            Iterator recordStoreIterator;
            RecordStore recordStore = partitionContainer.getExistingRecordStore(name);
            if (recordStore == null || !(recordStoreIterator = recordStore.iterator()).hasNext()) continue;
            Map.Entry entry = (Map.Entry)recordStoreIterator.next();
            return this.resolveMetadata(entry.getKey(), ((Record)entry.getValue()).getValue());
        }
        return null;
    }

    @Nullable
    private Metadata resolveMetadata(Object key, Object value) {
        InternalSerializationService ss = Util.getSerializationService((HazelcastInstance)this.nodeEngine.getHazelcastInstance());
        Metadata keyMetadata = SampleMetadataResolver.resolve(ss, key, true);
        Metadata valueMetadata = SampleMetadataResolver.resolve(ss, value, false);
        return keyMetadata != null && valueMetadata != null ? keyMetadata.merge(valueMetadata) : null;
    }
}

