/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexType;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProcessors;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.Joiner;
import com.hazelcast.jet.sql.impl.connector.map.MapIndexScanP;
import com.hazelcast.jet.sql.impl.connector.map.MetadataCompactResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataJsonResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.connector.map.RowProjectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdateProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdatingEntryProcessor;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.MapIndexScanMetadata;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IMapSqlConnector
implements SqlConnector {
    public static final IMapSqlConnector INSTANCE = new IMapSqlConnector();
    public static final String TYPE_NAME = "IMap";
    public static final List<String> PRIMARY_KEY_LIST = Collections.singletonList(QueryPath.KEY);
    private static final KvMetadataResolvers METADATA_RESOLVERS = new KvMetadataResolvers(KvMetadataJavaResolver.INSTANCE, MetadataPortableResolver.INSTANCE, MetadataCompactResolver.INSTANCE, MetadataJsonResolver.INSTANCE);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields) {
        return METADATA_RESOLVERS.resolveAndValidateFields(userFields, options, nodeEngine);
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        KvMetadata keyMetadata = METADATA_RESOLVERS.resolveMetadata(true, resolvedFields, options, ss);
        KvMetadata valueMetadata = METADATA_RESOLVERS.resolveMetadata(false, resolvedFields, options, ss);
        List fields = Stream.concat(keyMetadata.getFields().stream(), valueMetadata.getFields().stream()).collect(Collectors.toList());
        MapService service = (MapService)nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        MapContainer container = context.getExistingMapContainer(externalName);
        long estimatedRowCount = MapTableUtils.estimatePartitionedMapRowCount((NodeEngine)nodeEngine, (MapServiceContext)context, (String)externalName);
        boolean hd = container != null && container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        List indexes = container != null ? MapTableUtils.getPartitionedMapIndexes((MapContainer)container, fields) : Collections.emptyList();
        return new PartitionedMapTable(schemaName, mappingName, externalName, fields, (TableStatistics)new ConstantTableStatistics(estimatedRowCount), keyMetadata.getQueryTargetDescriptor(), valueMetadata.getQueryTargetDescriptor(), (Object)keyMetadata.getUpsertTargetDescriptor(), (Object)valueMetadata.getUpsertTargetDescriptor(), indexes, hd);
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> filter, @Nonnull List<Expression<?>> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of IMap mappings");
        }
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vStart = dag.newUniqueVertex(IMapSqlConnector.toString(table), SourceProcessors.readMapP((String)table.getMapName()));
        Vertex vEnd = dag.newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", RowProjectorProcessorSupplier.rowProjector(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), filter, projection));
        dag.edge(Edge.from((Vertex)vStart).to(vEnd).isolated());
        return vEnd;
    }

    @Nonnull
    public Vertex indexScanReader(@Nonnull DAG dag, @Nonnull Address localMemberAddress, @Nonnull Table table0, @Nonnull MapTableIndex tableIndex, @Nullable Expression<Boolean> remainingFilter, @Nonnull List<Expression<?>> projection, @Nullable IndexFilter indexFilter, @Nullable ComparatorEx<JetSqlRow> comparator, boolean descending) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        MapIndexScanMetadata indexScanMetadata = new MapIndexScanMetadata(table.getMapName(), tableIndex.getName(), table.getKeyDescriptor(), table.getValueDescriptor(), Arrays.asList(table.paths()), Arrays.asList(table.types()), indexFilter, projection, remainingFilter, comparator, descending);
        Vertex scanner = dag.newUniqueVertex("Index(" + IMapSqlConnector.toString(table) + ")", MapIndexScanP.readMapIndexSupplier(indexScanMetadata));
        scanner.localParallelism(1);
        if (tableIndex.getType() == IndexType.SORTED) {
            Vertex sorter = dag.newUniqueVertex("SortCombine", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)Processors.mapP((FunctionEx)FunctionEx.identity())), (Address)localMemberAddress));
            assert (comparator != null);
            dag.edge(Edge.between((Vertex)scanner, (Vertex)sorter).ordered(comparator).distributeTo(localMemberAddress).allToOne((Object)""));
            return sorter;
        }
        return scanner;
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig nestedLoopReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nonnull JetJoinInfo joinInfo) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        KvRowProjector.Supplier rightRowProjectorSupplier = KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), predicate, projections);
        return Joiner.join(dag, table.getMapName(), IMapSqlConnector.toString(table), joinInfo, rightRowProjectorSupplier);
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vertex = dag.newUniqueVertex(IMapSqlConnector.toString(table), (ProcessorSupplier)new InsertProcessorSupplier(table.getMapName(), KvProjector.supplier(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true))).localParallelism(1);
        return new SqlConnector.VertexWithInputConfig(vertex, edge -> edge.distributed().allToOne((Object)UuidUtil.newUnsecureUuidString()));
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vStart = dag.newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", KvProcessors.entryProjector(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true));
        Vertex vEnd = dag.newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.writeMapP((String)table.getMapName()));
        dag.edge(Edge.between((Vertex)vStart, (Vertex)vEnd));
        return vStart;
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull DAG dag, @Nonnull Table table0, @Nonnull Map<String, Expression<?>> updatesByFieldNames) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        return dag.newUniqueVertex("Update(" + IMapSqlConnector.toString(table) + ")", (ProcessorSupplier)new UpdateProcessorSupplier(table.getMapName(), UpdatingEntryProcessor.supplier(table, updatesByFieldNames)));
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        return dag.newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.updateMapP((String)table.getMapName(), (FunctionEx & Serializable)row -> {
            assert (row.getFieldCount() == 1);
            return row.get(0);
        }, (BiFunctionEx & Serializable)(v, t2) -> null));
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        return PRIMARY_KEY_LIST;
    }

    private static String toString(PartitionedMapTable table) {
        return "IMap[" + table.getSchemaName() + "." + table.getSqlName() + "]";
    }
}

