/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.QueryResultProducerImpl;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.jet.sql.impl.SqlResultImpl;
import com.hazelcast.jet.sql.impl.StaticQueryResultProducerImpl;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.UpdateSqlResultImpl;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class PlanExecutor {
    private static final String LE = System.lineSeparator();
    private static final String DEFAULT_UNIQUE_KEY = "__key";
    private static final String DEFAULT_UNIQUE_KEY_TRANSFORMATION = "OBJECT";
    private final TableResolverImpl catalog;
    private final HazelcastInstance hazelcastInstance;
    private final QueryResultRegistry resultRegistry;

    public PlanExecutor(TableResolverImpl catalog, HazelcastInstance hazelcastInstance, QueryResultRegistry resultRegistry) {
        this.catalog = catalog;
        this.hazelcastInstance = hazelcastInstance;
        this.resultRegistry = resultRegistry;
    }

    SqlResult execute(SqlPlanImpl.CreateMappingPlan plan) {
        this.catalog.createMapping(plan.mapping(), plan.replace(), plan.ifNotExists());
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.DropMappingPlan plan) {
        this.catalog.removeMapping(plan.name(), plan.ifExists());
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.CreateIndexPlan plan) {
        MapContainer mapContainer;
        if (!plan.ifNotExists() && (mapContainer = PlanExecutor.getMapContainer(this.hazelcastInstance.getMap(plan.mapName()))).getIndexes().getIndex(plan.indexName()) != null) {
            throw QueryException.error((String)("Can't create index: index '" + plan.indexName() + "' already exists"));
        }
        IndexConfig indexConfig = new IndexConfig(plan.indexType(), plan.attributes()).setName(plan.indexName());
        if (plan.indexType().equals((Object)IndexType.BITMAP)) {
            String uniqueKeyTransform;
            Map<String, String> options = plan.options();
            String uniqueKey = options.get("unique_key");
            if (uniqueKey == null) {
                uniqueKey = DEFAULT_UNIQUE_KEY;
            }
            if ((uniqueKeyTransform = options.get("unique_key_transformation")) == null) {
                uniqueKeyTransform = DEFAULT_UNIQUE_KEY_TRANSFORMATION;
            }
            BitmapIndexOptions bitmapIndexOptions = new BitmapIndexOptions();
            bitmapIndexOptions.setUniqueKey(uniqueKey);
            bitmapIndexOptions.setUniqueKeyTransformation(BitmapIndexOptions.UniqueKeyTransformation.fromName((String)uniqueKeyTransform));
            indexConfig.setBitmapIndexOptions(bitmapIndexOptions);
        }
        this.hazelcastInstance.getMap(plan.mapName()).addIndex(indexConfig);
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.CreateJobPlan plan, List<Object> arguments) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        JobConfig jobConfig = plan.getJobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)plan.isInfiniteRows());
        if (plan.isIfNotExists()) {
            this.hazelcastInstance.getJet().newJobIfAbsent(plan.getExecutionPlan().getDag(), jobConfig);
        } else {
            this.hazelcastInstance.getJet().newJob(plan.getExecutionPlan().getDag(), jobConfig);
        }
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.AlterJobPlan plan) {
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        switch (plan.getOperation()) {
            case SUSPEND: {
                job.suspend();
                break;
            }
            case RESUME: {
                job.resume();
                break;
            }
            case RESTART: {
                job.restart();
                break;
            }
        }
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.DropJobPlan plan) {
        boolean jobTerminated;
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        boolean bl = jobTerminated = job != null && job.getStatus().isTerminal();
        if (job == null || jobTerminated) {
            if (plan.isIfExists()) {
                return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
            }
            if (jobTerminated) {
                throw QueryException.error((String)("Job already terminated: " + plan.getJobName()));
            }
            throw QueryException.error((String)("Job doesn't exist: " + plan.getJobName()));
        }
        if (plan.getWithSnapshotName() != null) {
            job.cancelAndExportSnapshot(plan.getWithSnapshotName());
        } else {
            job.cancel();
        }
        try {
            job.join();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.CreateSnapshotPlan plan) {
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        job.exportSnapshot(plan.getSnapshotName());
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.DropSnapshotPlan plan) {
        JobStateSnapshot snapshot = this.hazelcastInstance.getJet().getJobStateSnapshot(plan.getSnapshotName());
        if (snapshot == null) {
            if (plan.isIfExists()) {
                return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
            }
            throw QueryException.error((String)("The snapshot doesn't exist: " + plan.getSnapshotName()));
        }
        snapshot.destroy();
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.CreateViewPlan plan) {
        View existingView;
        OptimizerContext context = plan.context();
        SqlNode sqlNode = context.parse(plan.viewQuery()).getNode();
        RelNode relNode = context.convert(sqlNode).getRel();
        List<RelDataTypeField> fieldList = relNode.getRowType().getFieldList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<QueryDataType> fieldTypes = new ArrayList<QueryDataType>();
        for (RelDataTypeField field : fieldList) {
            fieldNames.add(field.getName());
            fieldTypes.add(HazelcastTypeUtils.toHazelcastType(field.getType()));
        }
        View view = new View(plan.viewName(), plan.viewQuery(), plan.isStream(), fieldNames, fieldTypes);
        if (plan.isReplace() && (existingView = this.catalog.getView(plan.viewName())) != null) {
            PlanExecutor.checkViewNewRowType(existingView, view);
        }
        this.catalog.createView(view, plan.isReplace(), plan.ifNotExists());
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.DropViewPlan plan) {
        this.catalog.removeView(plan.viewName(), plan.isIfExists());
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.ShowStatementPlan plan) {
        Stream<String> rows;
        switch (plan.getShowTarget()) {
            case MAPPINGS: {
                rows = this.catalog.getMappingNames().stream();
                break;
            }
            case VIEWS: {
                rows = this.catalog.getViewNames().stream();
                break;
            }
            case JOBS: {
                assert (plan.getShowTarget() == SqlShowStatement.ShowStatementTarget.JOBS);
                NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance);
                JetServiceBackend jetServiceBackend = (JetServiceBackend)nodeEngine.getService("hz:impl:jetService");
                rows = jetServiceBackend.getJobRepository().getJobRecords().stream().map(record -> record.getConfig().getName()).filter(Objects::nonNull);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported SHOW statement target.");
            }
        }
        SqlRowMetadata metadata = new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR, false)));
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        return new SqlResultImpl(QueryId.create((UUID)this.hazelcastInstance.getLocalEndpoint().getUuid()), new StaticQueryResultProducerImpl(rows.sorted().map(name -> new JetSqlRow((SerializationService)serializationService, new Object[]{name})).iterator()), metadata, false);
    }

    SqlResult execute(SqlPlanImpl.ExplainStatementPlan plan) {
        SqlRowMetadata metadata = new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("rel", SqlColumnType.VARCHAR, false)));
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        Stream<String> planRows = Arrays.stream(plan.getRel().explain().split(LE));
        return new SqlResultImpl(QueryId.create((UUID)this.hazelcastInstance.getLocalEndpoint().getUuid()), new StaticQueryResultProducerImpl(planRows.map(rel -> new JetSqlRow((SerializationService)serializationService, new Object[]{rel})).iterator()), metadata, false);
    }

    SqlResult execute(SqlPlanImpl.SelectPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        JobConfig jobConfig = new JobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)plan.isStreaming()).setTimeoutMillis(timeout);
        QueryResultProducerImpl queryResultProducer = new QueryResultProducerImpl(!plan.isStreaming());
        AbstractJetInstance jet = (AbstractJetInstance)this.hazelcastInstance.getJet();
        long jobId = jet.newJobId();
        QueryResultProducer oldValue = this.resultRegistry.store(jobId, (QueryResultProducer)queryResultProducer);
        assert (oldValue == null) : oldValue;
        try {
            Job job = jet.newLightJob(jobId, plan.getDag(), jobConfig);
            job.getFuture().whenComplete((r, t2) -> {
                this.resultRegistry.remove(jobId);
                if (t2 != null) {
                    int errorCode = PlanExecutor.findQueryExceptionCode(t2);
                    String errorMessage = PlanExecutor.findQueryExceptionMessage(t2);
                    queryResultProducer.onError(QueryException.error((int)errorCode, (String)("The Jet SQL job failed: " + errorMessage), (Throwable)t2));
                }
            });
        }
        catch (Throwable e) {
            this.resultRegistry.remove(jobId);
            throw e;
        }
        return new SqlResultImpl(queryId, queryResultProducer, plan.getRowMetadata(), plan.isStreaming());
    }

    SqlResult execute(SqlPlanImpl.DmlPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        JobConfig jobConfig = new JobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)plan.isInfiniteRows()).setTimeoutMillis(timeout);
        Job job = this.hazelcastInstance.getJet().newLightJob(plan.getDag(), jobConfig);
        job.join();
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.IMapSelectPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        ExpressionEvalContext evalContext = new ExpressionEvalContext(args, serializationService);
        Object key = plan.keyCondition().eval((Row)EmptyRow.INSTANCE, evalContext);
        CompletionStage future = this.hazelcastInstance.getMap(plan.mapName()).getAsync(key).toCompletableFuture().thenApply(value -> plan.rowProjectorSupplier().get(evalContext, Extractors.newBuilder((InternalSerializationService)serializationService).build()).project(key, value));
        JetSqlRow row = (JetSqlRow)this.await((CompletableFuture)future, timeout);
        return new SqlResultImpl(queryId, new StaticQueryResultProducerImpl(row), plan.rowMetadata(), false);
    }

    SqlResult execute(SqlPlanImpl.IMapInsertPlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContext evalContext = new ExpressionEvalContext(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance));
        List<Map.Entry<Object, Object>> entries = plan.entriesFn().apply(evalContext);
        if (!entries.isEmpty()) {
            assert (entries.size() == 1);
            Map.Entry<Object, Object> entry = entries.get(0);
            CompletableFuture future = ((MapProxyImpl)this.hazelcastInstance.getMap(plan.mapName())).putIfAbsentAsync(entry.getKey(), entry.getValue()).toCompletableFuture();
            Object previous = this.await(future, timeout);
            if (previous != null) {
                throw QueryException.error((String)"Duplicate key");
            }
        }
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.IMapSinkPlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContext evalContext = new ExpressionEvalContext(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance));
        Map<Object, Object> entries = plan.entriesFn().apply(evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).putAllAsync(entries).toCompletableFuture();
        this.await(future, timeout);
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.IMapUpdatePlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContext evalContext = new ExpressionEvalContext(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance));
        Object key = plan.keyCondition().eval((Row)EmptyRow.INSTANCE, evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).submitToKey(key, plan.updaterSupplier().get(arguments)).toCompletableFuture();
        this.await(future, timeout);
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(SqlPlanImpl.IMapDeletePlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContext evalContext = new ExpressionEvalContext(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance));
        Object key = plan.keyCondition().eval((Row)EmptyRow.INSTANCE, evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).submitToKey(key, (EntryProcessor)EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR).toCompletableFuture();
        this.await(future, timeout);
        return UpdateSqlResultImpl.createUpdateCountResult((long)0L);
    }

    private List<Object> prepareArguments(QueryParameterMetadata parameterMetadata, List<Object> arguments) {
        assert (arguments != null);
        int parameterCount = parameterMetadata.getParameterCount();
        if (parameterCount != arguments.size()) {
            throw QueryException.error((int)2000, (String)("Unexpected parameter count: expected " + parameterCount + ", got " + arguments.size()));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Object value = arguments.get(i);
            ParameterConverter parameterConverter = parameterMetadata.getParameterConverter(i);
            Object newValue = parameterConverter.convert(value);
            if (newValue == value) continue;
            arguments.set(i, newValue);
        }
        return arguments;
    }

    private static void checkViewNewRowType(View original, View replacement) {
        int i;
        HashMap newTypes = new HashMap();
        for (i = 0; i < replacement.viewColumnNames().size(); ++i) {
            newTypes.put(replacement.viewColumnNames().get(i), replacement.viewColumnTypes().get(i));
        }
        for (i = 0; i < original.viewColumnNames().size(); ++i) {
            QueryDataType origType = (QueryDataType)original.viewColumnTypes().get(i);
            String origName = (String)original.viewColumnNames().get(i);
            QueryDataType newType = (QueryDataType)newTypes.get(origName);
            if (newType == null) {
                throw QueryException.error((String)("Can't replace view, the new view doesn't contain column '" + origName + "'"));
            }
            if (newType.getTypeFamily() == origType.getTypeFamily()) continue;
            throw QueryException.error((String)("Can't replace view, the type for column '" + origName + "' changed from " + origType.getTypeFamily() + " to " + newType.getTypeFamily()));
        }
    }

    private static int findQueryExceptionCode(Throwable t2) {
        while (t2 != null) {
            if (t2 instanceof QueryException) {
                return ((QueryException)t2).getCode();
            }
            t2 = t2.getCause();
        }
        return -1;
    }

    private static String findQueryExceptionMessage(Throwable t2) {
        while (t2 != null) {
            if (t2.getMessage() != null) {
                return t2.getMessage();
            }
            t2 = t2.getCause();
        }
        return "";
    }

    private <T> T await(CompletableFuture<T> future, long timeout) {
        try {
            return timeout > 0L ? future.get(timeout, TimeUnit.MILLISECONDS) : future.get();
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw QueryException.error((String)"Timeout occurred while executing statement");
        }
        catch (InterruptedException | ExecutionException e) {
            throw QueryException.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private static <K, V> MapContainer getMapContainer(IMap<K, V> map) {
        MapProxyImpl mapProxy = (MapProxyImpl)map;
        MapService mapService = (MapService)mapProxy.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(map.getName());
    }
}

