/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

final class Wkt {
    Wkt() {
    }

    public static double find_tolerance_from_wkt(String buffer) {
        double tolerance = -1.0;
        if (buffer != null && buffer.length() > 0) {
            int n1 = buffer.indexOf("PROJCS");
            if (n1 >= 0) {
                int n2;
                double factor = 0.0;
                n1 = buffer.lastIndexOf("UNIT");
                if (n1 >= 0 && (n1 = buffer.indexOf(44, n1 + 4)) > 0 && (n2 = buffer.indexOf(93, ++n1 + 1)) > 0) {
                    try {
                        factor = Double.parseDouble(buffer.substring(n1, n2));
                    }
                    catch (NumberFormatException e) {
                        factor = 0.0;
                    }
                }
                if (factor > 0.0) {
                    tolerance = 0.001 / factor;
                }
            } else {
                n1 = buffer.indexOf("GEOGCS");
                if (n1 >= 0) {
                    double axis = 0.0;
                    double factor = 0.0;
                    if ((n1 = buffer.indexOf("SPHEROID", n1 + 6)) > 0 && (n1 = buffer.indexOf(44, n1 + 8)) > 0) {
                        int n2;
                        if ((n2 = buffer.indexOf(44, ++n1 + 1)) > 0) {
                            try {
                                axis = Double.parseDouble(buffer.substring(n1, n2));
                            }
                            catch (NumberFormatException e) {
                                axis = 0.0;
                            }
                        }
                        if (axis > 0.0 && (n1 = buffer.indexOf("UNIT", n2 + 1)) >= 0 && (n1 = buffer.indexOf(44, n1 + 4)) > 0 && (n2 = buffer.indexOf(93, ++n1 + 1)) > 0) {
                            try {
                                factor = Double.parseDouble(buffer.substring(n1, n2));
                            }
                            catch (NumberFormatException e) {
                                factor = 0.0;
                            }
                        }
                    }
                    if (axis > 0.0 && factor > 0.0) {
                        tolerance = 0.001 / (axis * factor);
                    }
                }
            }
        }
        return tolerance;
    }
}

