/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.NumberUtils;
import com.hazelcast.com.esri.core.geometry.Point2D;

final class MathUtils {
    MathUtils() {
    }

    static double copySign(double x, double y) {
        return y >= 0.0 ? Math.abs(x) : -Math.abs(x);
    }

    static int sign(double value) {
        return value < 0.0 ? -1 : (value > 0.0 ? 1 : 0);
    }

    static double truncate(double v) {
        if (v >= 0.0) {
            return Math.floor(v);
        }
        return -Math.floor(-v);
    }

    static double FMod(double x, double y) {
        return x - MathUtils.truncate(x / y) * y;
    }

    static double round(double v) {
        return Math.floor(v + 0.5);
    }

    static double sqr(double v) {
        return v * v;
    }

    static double lerp(double start_, double end_, double t2) {
        double v = t2 <= 0.5 ? start_ + (end_ - start_) * t2 : end_ - (end_ - start_) * (1.0 - t2);
        assert (t2 < 0.0 || t2 > 1.0 || v >= start_ && v <= end_ || v <= start_ && v >= end_ || NumberUtils.isNaN(start_) || NumberUtils.isNaN(end_));
        return v;
    }

    static void lerp(Point2D start_, Point2D end_, double t2, Point2D result) {
        double ry;
        double rx;
        assert (start_ != result);
        if (t2 <= 0.5) {
            rx = start_.x + (end_.x - start_.x) * t2;
            ry = start_.y + (end_.y - start_.y) * t2;
        } else {
            rx = end_.x - (end_.x - start_.x) * (1.0 - t2);
            ry = end_.y - (end_.y - start_.y) * (1.0 - t2);
        }
        assert (t2 < 0.0 || t2 > 1.0 || rx >= start_.x && rx <= end_.x || rx <= start_.x && rx >= end_.x);
        assert (t2 < 0.0 || t2 > 1.0 || ry >= start_.y && ry <= end_.y || ry <= start_.y && ry >= end_.y);
        result.x = rx;
        result.y = ry;
    }

    static void lerp(double start_x, double start_y, double end_x, double end_y, double t2, Point2D result) {
        if (t2 <= 0.5) {
            result.x = start_x + (end_x - start_x) * t2;
            result.y = start_y + (end_y - start_y) * t2;
        } else {
            result.x = end_x - (end_x - start_x) * (1.0 - t2);
            result.y = end_y - (end_y - start_y) * (1.0 - t2);
        }
        assert (t2 < 0.0 || t2 > 1.0 || result.x >= start_x && result.x <= end_x || result.x <= start_x && result.x >= end_x);
        assert (t2 < 0.0 || t2 > 1.0 || result.y >= start_y && result.y <= end_y || result.y <= start_y && result.y >= end_y);
    }

    static final class KahanSummator {
        private double sum;
        private double compensation;
        private double startValue;

        KahanSummator(double startValue_) {
            this.startValue = startValue_;
            this.reset();
        }

        void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
        }

        void add(double v) {
            double y = v - this.compensation;
            double t2 = this.sum + y;
            double h2 = t2 - this.sum;
            this.compensation = h2 - y;
            this.sum = t2;
        }

        void sub(double v) {
            this.add(-v);
        }

        void add(KahanSummator v) {
            double y = v.getResult() + v.compensation - this.compensation;
            double t2 = this.sum + y;
            double h2 = t2 - this.sum;
            this.compensation = h2 - y;
            this.sum = t2;
        }

        void sub(KahanSummator v) {
            double y = -(v.getResult() - v.compensation) - this.compensation;
            double t2 = this.sum + y;
            double h2 = t2 - this.sum;
            this.compensation = h2 - y;
            this.sum = t2;
        }

        double getResult() {
            return this.startValue + this.sum;
        }

        KahanSummator plusEquals(double v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(double v) {
            this.add(-v);
            return this;
        }

        KahanSummator plusEquals(KahanSummator v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(KahanSummator v) {
            this.sub(v);
            return this;
        }
    }
}

