/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.lucene;

import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;

public class SegmentWrapper {
    private Reader input;
    private Segment segment;
    private Iterator<Term> iterator;
    int offset;
    private static final int BUFFER_SIZE = 512;
    private char[] buffer = new char[512];
    private int remainSize = 0;

    public SegmentWrapper(Reader reader, Segment segment) {
        this.input = reader;
        this.segment = segment;
    }

    public void reset(Reader reader) {
        this.input = reader;
        this.offset = 0;
        this.iterator = null;
    }

    public Term next() throws IOException {
        if (this.iterator != null && this.iterator.hasNext()) {
            return this.iterator.next();
        }
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        List termList = this.segment.seg(line);
        if (termList.size() == 0) {
            return null;
        }
        for (Term term : termList) {
            term.offset += this.offset;
        }
        this.offset += line.length();
        this.iterator = termList.iterator();
        return this.iterator.next();
    }

    private String readLine() throws IOException {
        int n;
        int offset = 0;
        int length = 512;
        if (this.remainSize > 0) {
            offset = this.remainSize;
            length -= this.remainSize;
        }
        if ((n = this.input.read(this.buffer, offset, length)) < 0) {
            if (this.remainSize != 0) {
                String lastLine = new String(this.buffer, 0, this.remainSize);
                this.remainSize = 0;
                return lastLine;
            }
            return null;
        }
        int eos = this.lastIndexOfEos(this.buffer, n += offset);
        String line = new String(this.buffer, 0, eos);
        this.remainSize = n - eos;
        System.arraycopy(this.buffer, eos, this.buffer, 0, this.remainSize);
        return line;
    }

    private int lastIndexOfEos(char[] buffer, int length) {
        for (int i = length - 1; i > 0; --i) {
            if (buffer[i] != '\n' && CharType.get((char)buffer[i]) != 6) continue;
            return i + 1;
        }
        return length;
    }
}

