/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.SimpleDictionary;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.Map;

public class StringDictionary
extends SimpleDictionary<String> {
    protected String separator;

    public StringDictionary(String separator) {
        this.separator = separator;
    }

    public StringDictionary() {
        this("=");
    }

    @Override
    protected Map.Entry<String, String> onGenerateEntry(String line) {
        String[] paramArray = line.split(this.separator, 2);
        if (paramArray.length != 2) {
            Predefine.logger.warning("\u8bcd\u5178\u6709\u4e00\u884c\u8bfb\u53d6\u9519\u8bef\uff1a " + line);
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(paramArray[0], paramArray[1]);
    }

    public boolean save(String path) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path)));
            for (Map.Entry entry : this.trie.entrySet()) {
                bw.write(entry.getKey());
                bw.write(this.separator);
                bw.write((String)entry.getValue());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u8bcd\u5178\u5230" + path + "\u5931\u8d25");
            return true;
        }
        return false;
    }

    public StringDictionary reverse() {
        StringDictionary dictionary = new StringDictionary(this.separator);
        for (Map.Entry entry : this.entrySet()) {
            dictionary.trie.put((String)entry.getValue(), entry.getKey());
        }
        return dictionary;
    }
}

