/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;
    private Table table;
    private DropTable next;

    public DropTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void addNextDropTable(DropTable dropTable) {
        if (this.next == null) {
            this.next = dropTable;
        } else {
            this.next.addNextDropTable(dropTable);
        }
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
        if (this.next != null) {
            this.next.setIfExists(bl);
        }
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    private void prepareDrop() throws SQLException {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(42102, this.tableName);
            }
        } else {
            this.session.getUser().checkRight(this.table, 15);
            if (!this.table.canDrop()) {
                throw Message.getSQLException(90118, this.tableName);
            }
            this.table.lock(this.session, true, true);
        }
        if (this.next != null) {
            this.next.prepareDrop();
        }
    }

    private void executeDrop() throws SQLException {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table != null) {
            this.table.setModified();
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, this.table);
        }
        if (this.next != null) {
            this.next.executeDrop();
        }
    }

    public int update() throws SQLException {
        this.session.commit(true);
        this.prepareDrop();
        this.executeDrop();
        return 0;
    }
}

