/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int PRECISION = 6;
    public static final int DISPLAY_SIZE = 8;
    private final Time value;

    private ValueTime(Time time) {
        this.value = time;
    }

    public static Time parseTime(String string) throws SQLException {
        return (Time)DateTimeUtils.parseDateTime(string, 9, 90010);
    }

    public Time getTime() {
        return (Time)this.value.clone();
    }

    public Time getTimeNoCopy() {
        return this.value;
    }

    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    public int getType() {
        return 9;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTime valueTime = (ValueTime)value;
        int n = this.value.compareTo(valueTime.value);
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public String getString() {
        return this.value.toString();
    }

    public long getPrecision() {
        return 6L;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getTime();
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTime(n, this.value);
    }

    public static ValueTime get(Time time) {
        time = DateTimeUtils.cloneAndNormalizeTime(time);
        return ValueTime.getNoCopy(time);
    }

    public static ValueTime getNoCopy(Time time) {
        return (ValueTime)Value.cache(new ValueTime(time));
    }

    public int getDisplaySize() {
        return 8;
    }

    public boolean equals(Object object) {
        return object instanceof ValueTime && this.value.equals(((ValueTime)object).value);
    }
}

