/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.util.HashBase;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap
extends HashBase {
    private Value[] keys;
    private Object[] values;
    private DataHandler database;

    public ValueHashMap(DataHandler dataHandler) {
        this.database = dataHandler;
    }

    protected void reset(int n) {
        super.reset(n);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    protected void rehash(int n) throws SQLException {
        Value[] valueArray = this.keys;
        Object[] objectArray = this.values;
        this.reset(n);
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            if (value == null || value == ValueNull.DELETED) continue;
            this.put(value, objectArray[i]);
        }
    }

    private int getIndex(Value value) {
        return value.hashCode() & this.mask;
    }

    public void put(Value value, Object object) throws SQLException {
        this.checkSizePut();
        int n = this.getIndex(value);
        int n2 = 1;
        int n3 = -1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                if (n3 >= 0) {
                    n = n3;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n] = value;
                this.values[n] = object;
                return;
            }
            if (value2 == ValueNull.DELETED) {
                if (n3 < 0) {
                    n3 = n;
                }
            } else if (this.database.compareTypeSave(value2, value) == 0) {
                this.values[n] = object;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        throw Message.getInternalError("hashmap is full");
    }

    public void remove(Value value) throws SQLException {
        this.checkSizeRemove();
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return;
            }
            if (value2 != ValueNull.DELETED && this.database.compareTypeSave(value2, value) == 0) {
                this.keys[n] = ValueNull.DELETED;
                this.values[n] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
    }

    public Object get(Value value) throws SQLException {
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return null;
            }
            if (value2 != ValueNull.DELETED && this.database.compareTypeSave(value2, value) == 0) {
                return this.values[n];
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        return null;
    }

    public ObjectArray keys() {
        ObjectArray objectArray = new ObjectArray(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value value = this.keys[i];
            if (value == null || value == ValueNull.DELETED) continue;
            objectArray.add(value);
        }
        return objectArray;
    }

    public ObjectArray values() {
        ObjectArray objectArray = new ObjectArray(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value value = this.keys[i];
            if (value == null || value == ValueNull.DELETED) continue;
            objectArray.add(this.values[i]);
        }
        return objectArray;
    }
}

