/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

public class TableLink
extends Table {
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private Connection conn;
    private HashMap prepared = new HashMap();
    private final ObjectArray indexes = new ObjectArray();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private SQLException connectException;

    public TableLink(Schema schema, int id, String name, String driver, String url, String user, String password, String originalTable, boolean emitUpdates, boolean force) throws SQLException {
        super(schema, id, name, false);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.originalTable = originalTable;
        this.emitUpdates = emitUpdates;
        try {
            this.connect();
        }
        catch (SQLException e) {
            this.connectException = e;
            if (!force) {
                throw e;
            }
            Column[] cols = new Column[]{};
            this.setColumns(cols);
            this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap(cols), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() throws SQLException {
        Object col;
        int type;
        int displaySize;
        int scale;
        long precision;
        int sqlType;
        String n;
        this.conn = JdbcUtils.getConnection(this.driver, this.url, this.user, this.password);
        DatabaseMetaData meta = this.conn.getMetaData();
        boolean storesLowerCase = meta.storesLowerCaseIdentifiers();
        ResultSet rs = meta.getColumns(null, null, this.originalTable, null);
        int i = 0;
        ObjectArray columnList = new ObjectArray();
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        String catalog = null;
        String schema = null;
        while (rs.next()) {
            String thisCatalog = rs.getString("TABLE_CAT");
            if (catalog == null) {
                catalog = thisCatalog;
            }
            String thisSchema = rs.getString("TABLE_SCHEM");
            if (schema == null) {
                schema = thisSchema;
            }
            if (!StringUtils.equals(catalog, thisCatalog) || !StringUtils.equals(schema, thisSchema)) {
                columnMap.clear();
                columnList.clear();
                break;
            }
            n = rs.getString("COLUMN_NAME");
            if (storesLowerCase && n.equals(StringUtils.toLowerEnglish(n))) {
                n = StringUtils.toUpperEnglish(n);
            }
            sqlType = rs.getInt("DATA_TYPE");
            precision = rs.getInt("COLUMN_SIZE");
            scale = rs.getInt("DECIMAL_DIGITS");
            displaySize = MathUtils.convertLongToInt(precision);
            type = DataType.convertSQLTypeToValueType(sqlType);
            col = new Column(n, type, precision, scale, displaySize);
            ((Column)col).setTable(this, i++);
            columnList.add(col);
            columnMap.put(n, (Column)col);
        }
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(schema) ? schema + "." + this.originalTable : this.originalTable;
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            rs = stat.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
            if (columnList.size() == 0) {
                ResultSetMetaData rsMeta = rs.getMetaData();
                i = 0;
                while (i < rsMeta.getColumnCount()) {
                    n = rsMeta.getColumnName(i + 1);
                    if (storesLowerCase && n.equals(StringUtils.toLowerEnglish(n))) {
                        n = StringUtils.toUpperEnglish(n);
                    }
                    sqlType = rsMeta.getColumnType(i + 1);
                    precision = rsMeta.getPrecision(i + 1);
                    scale = rsMeta.getScale(i + 1);
                    displaySize = rsMeta.getColumnDisplaySize(i + 1);
                    type = DataType.convertSQLTypeToValueType(sqlType);
                    col = new Column(n, type, precision, scale, displaySize);
                    ((Column)col).setTable(this, i++);
                    columnList.add(col);
                    columnMap.put(n, (Column)col);
                }
            }
        }
        catch (SQLException e) {
            throw Message.getSQLException(42102, new String[]{this.originalTable + "(" + e.toString() + ")"}, e);
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
        Object[] cols = new Column[columnList.size()];
        columnList.toArray(cols);
        this.setColumns((Column[])cols);
        int id = this.getId();
        this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap((Column[])cols), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        rs = meta.getPrimaryKeys(null, null, this.originalTable);
        String pkName = "";
        if (rs.next()) {
            ObjectArray list = new ObjectArray();
            do {
                int idx = rs.getInt("KEY_SEQ");
                if (pkName == null) {
                    pkName = rs.getString("PK_NAME");
                }
                while (list.size() < idx) {
                    list.add(null);
                }
                String col2 = rs.getString("COLUMN_NAME");
                Column column = (Column)columnMap.get(col2);
                list.set(idx - 1, column);
            } while (rs.next());
            this.addIndex(list, IndexType.createPrimaryKey(false, false));
        }
        try {
            rs = meta.getIndexInfo(null, null, this.originalTable, false, false);
        }
        catch (SQLException e) {
            rs = null;
        }
        String indexName = null;
        ObjectArray list = new ObjectArray();
        IndexType indexType = null;
        while (rs != null && rs.next()) {
            String newIndex = rs.getString("INDEX_NAME");
            if (pkName.equals(newIndex)) continue;
            if (indexName != null && !indexName.equals(newIndex)) {
                this.addIndex(list, indexType);
                indexName = null;
            }
            if (indexName == null) {
                indexName = newIndex;
                list.clear();
            }
            boolean unique = !rs.getBoolean("NON_UNIQUE");
            indexType = unique ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
            col = rs.getString("COLUMN_NAME");
            Column column = (Column)columnMap.get(col);
            list.add(column);
        }
        if (indexName != null) {
            this.addIndex(list, indexType);
        }
    }

    private void addIndex(ObjectArray list, IndexType indexType) {
        Object[] cols = new Column[list.size()];
        list.toArray(cols);
        LinkedIndex index = new LinkedIndex(this, 0, IndexColumn.wrap((Column[])cols), indexType);
        this.indexes.add(index);
    }

    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE FORCE LINKED TABLE ");
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append("(");
        buff.append(StringUtils.quoteStringSQL(this.driver));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.url));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.user));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.password));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.originalTable));
        buff.append(")");
        if (this.emitUpdates) {
            buff.append(" EMIT UPDATES");
        }
        return buff.toString();
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, int headPos, String comment) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    public void removeRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).remove(session, row);
    }

    public void addRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    public long getRowCount(Session session) throws SQLException {
        PreparedStatement prep = this.getPreparedStatement("SELECT COUNT(*) FROM " + this.qualifiedTableName);
        ResultSet rs = prep.executeQuery();
        rs.next();
        long count = rs.getLong(1);
        rs.close();
        return count;
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.conn == null) {
            throw this.connectException;
        }
        PreparedStatement prep = (PreparedStatement)this.prepared.get(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
            this.prepared.put(sql, prep);
        }
        return prep;
    }

    public void unlock(Session s) {
    }

    public void checkRename() throws SQLException {
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public String getTableType() {
        return "TABLE LINK";
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.conn = null;
        this.prepared = null;
        this.invalidate();
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index idx = (Index)this.indexes.get(i);
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    public void updateRows(Prepared prepared, Session session, RowList rows) throws SQLException {
        boolean deleteInsert;
        if (this.emitUpdates) {
            rows.reset();
            while (rows.hasNext()) {
                session.checkCancelled();
                Row oldRow = rows.next();
                Row newRow = rows.next();
                this.linkedIndex.update(session, oldRow, newRow);
                session.log(this, (short)1, oldRow);
                session.log(this, (short)0, newRow);
            }
            deleteInsert = false;
        } else {
            deleteInsert = true;
        }
        if (deleteInsert) {
            super.updateRows(prepared, session, rows);
        }
    }
}

