/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LogFile;
import org.h2.store.LogRecord;
import org.h2.store.Record;
import org.h2.store.SessionState;
import org.h2.store.Storage;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

public class LogSystem {
    public static final int LOG_WRITTEN = -1;
    private Database database;
    private ObjectArray activeLogs;
    private LogFile currentLog;
    private String fileNamePrefix;
    private HashMap storages = new HashMap();
    private HashMap sessions = new HashMap();
    private DataPage rowBuff;
    private ObjectArray undo;
    private boolean deleteOldLogFilesAutomatically = true;
    private long maxLogSize = 0x2000000L;
    private boolean readOnly;
    private boolean flushOnEachCommit;
    private ObjectArray inDoubtTransactions;
    private boolean disabled;
    private int keepFiles;
    private boolean closed;
    private String accessMode;

    public LogSystem(Database database, String fileNamePrefix, boolean readOnly, String accessMode) throws SQLException {
        this.database = database;
        this.readOnly = readOnly;
        this.accessMode = accessMode;
        if (database == null) {
            return;
        }
        this.fileNamePrefix = fileNamePrefix;
        this.rowBuff = DataPage.create((DataHandler)database, 512);
        this.loadActiveLogFiles();
    }

    public void setMaxLogSize(long maxSize) {
        this.maxLogSize = maxSize;
    }

    public long getMaxLogSize() {
        return this.maxLogSize;
    }

    public boolean containsInDoubtTransactions() {
        return this.inDoubtTransactions != null && this.inDoubtTransactions.size() > 0;
    }

    private void flushAndCloseUnused() throws SQLException {
        LogFile l;
        int i;
        this.currentLog.flush();
        DiskFile file = this.database.getDataFile();
        if (file == null) {
            return;
        }
        file.flush();
        if (this.containsInDoubtTransactions()) {
            return;
        }
        Session[] sessions = this.database.getSessions();
        int firstUncommittedLog = this.currentLog.getId();
        int firstUncommittedPos = this.currentLog.getPos();
        for (i = 0; i < sessions.length; ++i) {
            Session session = sessions[i];
            int log = session.getFirstUncommittedLog();
            int pos = session.getFirstUncommittedPos();
            if (pos == -1 || log >= firstUncommittedLog && (log != firstUncommittedLog || pos >= firstUncommittedPos)) continue;
            firstUncommittedLog = log;
            firstUncommittedPos = pos;
        }
        for (i = this.activeLogs.size() - 1; i >= 0; --i) {
            l = (LogFile)this.activeLogs.get(i);
            if (l.getId() < firstUncommittedLog) {
                l.setFirstUncommittedPos(-1);
                continue;
            }
            if (l.getId() != firstUncommittedLog) continue;
            if (firstUncommittedPos == l.getPos()) {
                l.setFirstUncommittedPos(-1);
                continue;
            }
            l.setFirstUncommittedPos(firstUncommittedPos);
        }
        for (i = 0; i < this.activeLogs.size(); ++i) {
            l = (LogFile)this.activeLogs.get(i);
            if (l.getFirstUncommittedPos() != -1) continue;
            this.activeLogs.remove(i);
            --i;
            this.closeOldFile(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            if (this.readOnly) {
                for (int i = 0; i < this.activeLogs.size(); ++i) {
                    LogFile l = (LogFile)this.activeLogs.get(i);
                    l.close(false);
                }
                this.closed = true;
                return;
            }
            SQLException closeException = null;
            try {
                this.flushAndCloseUnused();
                if (!this.containsInDoubtTransactions()) {
                    this.checkpoint();
                }
            }
            catch (SQLException e) {
                closeException = e;
            }
            for (int i = 0; i < this.activeLogs.size(); ++i) {
                LogFile l = (LogFile)this.activeLogs.get(i);
                try {
                    if (l.getFirstUncommittedPos() == -1 && !this.containsInDoubtTransactions()) {
                        this.closeOldFile(l);
                        continue;
                    }
                    l.close(false);
                    continue;
                }
                catch (SQLException e) {
                    if (closeException != null) continue;
                    closeException = e;
                }
            }
            this.closed = true;
            if (closeException != null) {
                throw closeException;
            }
        }
    }

    boolean needMoreUndo() {
        return this.sessions.size() > 0;
    }

    void addUndoLogRecord(LogFile log, int logRecordId, int sessionId) {
        LogRecord record = new LogRecord(log, logRecordId, sessionId);
        this.undo.add(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws SQLException {
        if (this.database == null) {
            return false;
        }
        Database database = this.database;
        synchronized (database) {
            int i;
            if (this.closed) {
                return false;
            }
            this.undo = new ObjectArray();
            for (int i2 = 0; i2 < this.activeLogs.size(); ++i2) {
                LogFile log = (LogFile)this.activeLogs.get(i2);
                log.redoAllGoEnd();
            }
            this.database.getDataFile().flushRedoLog();
            this.database.getIndexFile().flushRedoLog();
            int end = this.currentLog.getPos();
            Object[] states = this.sessions.values().toArray();
            this.inDoubtTransactions = new ObjectArray();
            for (i = 0; i < states.length; ++i) {
                SessionState state = (SessionState)states[i];
                if (state.inDoubtTransaction == null) continue;
                this.inDoubtTransactions.add(state.inDoubtTransaction);
            }
            for (i = this.undo.size() - 1; i >= 0 && this.sessions.size() > 0; --i) {
                this.database.setProgress(2, null, this.undo.size() - 1 - i, this.undo.size());
                LogRecord record = (LogRecord)this.undo.get(i);
                if (this.sessions.get(ObjectUtils.getInteger(record.sessionId)) == null) continue;
                record.log.undo(record.logRecordId);
                this.database.getDataFile().flushRedoLog();
                this.database.getIndexFile().flushRedoLog();
            }
            this.currentLog.go(end);
            boolean fileChanged = this.undo.size() > 0;
            this.undo = null;
            this.storages.clear();
            if (!this.readOnly && fileChanged && !this.containsInDoubtTransactions()) {
                this.checkpoint();
            }
            return fileChanged;
        }
    }

    private void closeOldFile(LogFile l) throws SQLException {
        l.close(this.deleteOldLogFilesAutomatically && this.keepFiles == 0);
    }

    private void loadActiveLogFiles() throws SQLException {
        String path = FileUtils.getParent(this.fileNamePrefix);
        String[] list = FileUtils.listFiles(path);
        this.activeLogs = new ObjectArray();
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            LogFile l = null;
            try {
                l = LogFile.openIfLogFile(this, this.fileNamePrefix, s);
            }
            catch (SQLException e) {
                this.database.getTrace("log").debug("Error opening log file, header corrupt: " + s, e);
                FileUtils.rename(s, s + ".corrupt");
            }
            if (l == null) continue;
            if (l.getPos() == -1) {
                this.closeOldFile(l);
                continue;
            }
            this.activeLogs.add(l);
        }
        this.activeLogs.sort(new Comparator(){

            public int compare(Object a, Object b) {
                return ((LogFile)a).getId() - ((LogFile)b).getId();
            }
        });
        if (this.activeLogs.size() == 0) {
            LogFile l = new LogFile(this, 0, this.fileNamePrefix);
            this.activeLogs.add(l);
        }
        this.currentLog = (LogFile)this.activeLogs.get(this.activeLogs.size() - 1);
    }

    Storage getStorageForRecovery(int id) throws SQLException {
        boolean dataFile;
        if (id < 0) {
            dataFile = false;
            id = -id;
        } else {
            dataFile = true;
        }
        Integer i = ObjectUtils.getInteger(id);
        Storage storage = (Storage)this.storages.get(i);
        if (storage == null) {
            storage = this.database.getStorage(null, id, dataFile);
            this.storages.put(i, storage);
        }
        return storage;
    }

    boolean isSessionCommitted(int sessionId, int logId, int pos) {
        Integer key = ObjectUtils.getInteger(sessionId);
        SessionState state = (SessionState)this.sessions.get(key);
        if (state == null) {
            return true;
        }
        return state.isCommitted(logId, pos);
    }

    void setLastCommitForSession(int sessionId, int logId, int pos) {
        Integer key = ObjectUtils.getInteger(sessionId);
        SessionState state = (SessionState)this.sessions.get(key);
        if (state == null) {
            state = new SessionState();
            this.sessions.put(key, state);
            state.sessionId = sessionId;
        }
        state.lastCommitLog = logId;
        state.lastCommitPos = pos;
        state.inDoubtTransaction = null;
    }

    void setPreparedCommitForSession(LogFile log, int sessionId, int pos, String transaction, int blocks) {
        Integer key = ObjectUtils.getInteger(sessionId);
        SessionState state = (SessionState)this.sessions.get(key);
        if (state == null) {
            state = new SessionState();
            this.sessions.put(key, state);
            state.sessionId = sessionId;
        }
        this.setLastCommitForSession(sessionId, log.getId(), pos);
        state.inDoubtTransaction = new InDoubtTransaction(log, sessionId, pos, transaction, blocks);
    }

    public ObjectArray getInDoubtTransactions() {
        return this.inDoubtTransactions;
    }

    void removeSession(int sessionId) {
        this.sessions.remove(ObjectUtils.getInteger(sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String transaction) throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.prepareCommit(session, transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.commit(session);
            session.setAllCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTruncate(Session session, DiskFile file, int storageId, int recordId, int blockCount) throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.disabled || this.closed) {
                return;
            }
            this.database.checkWritingAllowed();
            if (!file.isDataFile()) {
                storageId = -storageId;
            }
            this.currentLog.addTruncate(session, storageId, recordId, blockCount);
            if (this.currentLog.getFileSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, DiskFile file, Record record) throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.disabled || this.closed) {
                return;
            }
            this.database.checkWritingAllowed();
            int storageId = record.getStorageId();
            if (!file.isDataFile()) {
                storageId = -storageId;
            }
            int log = this.currentLog.getId();
            int pos = this.currentLog.getPos();
            session.addLogPos(log, pos);
            record.setLastLog(log, pos);
            this.currentLog.add(session, storageId, record);
            if (this.currentLog.getFileSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws SQLException {
        if (this.readOnly || this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed || this.disabled) {
                return;
            }
            this.flushAndCloseUnused();
            this.currentLog = new LogFile(this, this.currentLog.getId() + 1, this.fileNamePrefix);
            this.activeLogs.add(this.currentLog);
            this.writeSummary();
            this.currentLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectArray getActiveLogFiles() {
        Database database = this.database;
        synchronized (database) {
            ObjectArray list = new ObjectArray();
            list.addAll(this.activeLogs);
            return list;
        }
    }

    private void writeSummary() throws SQLException {
        DiskFile file = this.database.getDataFile();
        byte[] summary = file.getSummary();
        if (summary != null) {
            this.currentLog.addSummary(true, summary);
        }
        if (this.database.getLogIndexChanges() || this.database.getIndexSummaryValid()) {
            file = this.database.getIndexFile();
            summary = file.getSummary();
            if (summary != null) {
                this.currentLog.addSummary(false, summary);
            }
        } else {
            this.currentLog.addSummary(false, null);
        }
    }

    Database getDatabase() {
        return this.database;
    }

    DataPage getRowBuffer() {
        return this.rowBuff;
    }

    public void setFlushOnEachCommit(boolean b) {
        this.flushOnEachCommit = b;
    }

    boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.currentLog != null) {
                this.currentLog.flush();
                this.currentLog.sync();
            }
        }
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    void addRedoLog(Storage storage, int recordId, int blockCount, DataPage rec) throws SQLException {
        DiskFile file = storage.getDiskFile();
        file.addRedoLog(storage, recordId, blockCount, rec);
    }

    public void invalidateIndexSummary() throws SQLException {
        this.currentLog.addSummary(false, null);
    }

    public synchronized void updateKeepFiles(int incrementDecrement) {
        this.keepFiles += incrementDecrement;
    }

    String getAccessMode() {
        return this.accessMode;
    }
}

