/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceSystem;

public class Driver
implements java.sql.Driver {
    private static final Driver instance = new Driver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            if (info == null) {
                info = new Properties();
            }
            if (!this.acceptsURL(url)) {
                return null;
            }
            Driver driver = this;
            synchronized (driver) {
                return new JdbcConnection(url, info);
            }
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public boolean acceptsURL(String url) {
        return url != null && url.startsWith("jdbc:h2:");
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static Driver load() {
        return instance;
    }

    static {
        try {
            DriverManager.registerDriver(instance);
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
    }
}

