package com.groupbyinc.common.util.logging;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/**
 * Logging context
 *
 * @author Ben Teichman
 */
public class LoggingContext {

    private static final transient Logger LOG = LoggerFactory.getLogger(LoggingContext.class);

    public enum Key {
        CustomerId("customerId");

        String value;

        Key(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    private static final String UNKNOWN = "<UNKNOWN>";

    public static void init() {
        // set all values to unknown
        LOG.debug("initializing all values as '{}'", UNKNOWN);
        for (Key key : Key.values()) {
            MDC.put(key.getValue(), UNKNOWN);
        }
    }

    public static void set(Key key, String value) {
        String keyValue = key.getValue();
        if (StringUtils.isNotBlank(value)) {
            LOG.debug("setting '{}' to '{}'", keyValue, value);
            MDC.put(keyValue, value);
        } else {
            LOG.debug("'{}' must not be blank", keyValue);
        }
    }

}
