/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.reactive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.reactive.AbstractBatchSubscriber;
import org.dataloader.reactive.ReactiveSupport;

class MappedBatchSubscriberImpl<K, V>
extends AbstractBatchSubscriber<K, V, Map.Entry<K, V>> {
    private final Map<K, Object> callContextByKey;
    private final Map<K, List<CompletableFuture<V>>> queuedFuturesByKey;
    private final Map<K, V> completedValuesByKey = new HashMap();

    MappedBatchSubscriberImpl(CompletableFuture<List<V>> valuesFuture, List<K> keys, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures, ReactiveSupport.HelperIntegration<K> helperIntegration) {
        super(valuesFuture, keys, callContexts, queuedFutures, helperIntegration);
        this.callContextByKey = new HashMap<K, Object>();
        this.queuedFuturesByKey = new HashMap<K, List<CompletableFuture<V>>>();
        for (int idx = 0; idx < queuedFutures.size(); ++idx) {
            K key = keys.get(idx);
            Object callContext = callContexts.get(idx);
            CompletableFuture<V> queuedFuture = queuedFutures.get(idx);
            this.callContextByKey.put(key, callContext);
            this.queuedFuturesByKey.computeIfAbsent(key, k -> new ArrayList()).add(queuedFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(Map.Entry<K, V> entry) {
        try {
            this.lock.lock();
            super.onNext(entry);
            K key = entry.getKey();
            V value = entry.getValue();
            Object callContext = this.callContextByKey.get(key);
            List futures = this.queuedFuturesByKey.getOrDefault(key, List.of());
            this.onNextValue(key, value, callContext, futures);
            if (!futures.isEmpty()) {
                this.completedValuesByKey.put(key, value);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        try {
            this.lock.lock();
            super.onComplete();
            this.possiblyClearCacheEntriesOnExceptions();
            ArrayList<V> values = new ArrayList<V>(this.keys.size());
            for (Object key : this.keys) {
                V value = this.completedValuesByKey.get(key);
                values.add(value);
                List futures = this.queuedFuturesByKey.getOrDefault(key, List.of());
                for (CompletableFuture future : futures) {
                    if (future.isDone()) continue;
                    future.complete(null);
                }
            }
            this.valuesFuture.complete(values);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable ex) {
        try {
            this.lock.lock();
            super.onError(ex);
            ex = this.unwrapThrowable(ex);
            for (int idx = 0; idx < this.queuedFutures.size(); ++idx) {
                Object key = this.keys.get(idx);
                List<CompletableFuture<V>> futures = this.queuedFuturesByKey.get(key);
                if (this.completedValuesByKey.containsKey(key)) continue;
                for (CompletableFuture<V> future : futures) {
                    future.completeExceptionally(ex);
                }
                this.helperIntegration.clearCacheView(key);
            }
            this.valuesFuture.completeExceptionally(ex);
        }
        finally {
            this.lock.unlock();
        }
    }
}

