/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.cache.BufferedHttpServletResponse;
import graphql.kickstart.servlet.cache.CachedResponse;
import graphql.kickstart.servlet.cache.GraphQLResponseCacheManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingQueryResponseWriter
implements QueryResponseWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachingQueryResponseWriter.class);
    private final QueryResponseWriter delegate;
    private final GraphQLResponseCacheManager responseCache;
    private final GraphQLInvocationInput invocationInput;
    private final boolean error;

    public CachingQueryResponseWriter(QueryResponseWriter delegate, GraphQLResponseCacheManager responseCache, GraphQLInvocationInput invocationInput, boolean error) {
        this.delegate = delegate;
        this.responseCache = responseCache;
        this.invocationInput = invocationInput;
        this.error = error;
    }

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.responseCache.isCacheable(request, this.invocationInput)) {
            BufferedHttpServletResponse cachingResponseWrapper = new BufferedHttpServletResponse(response);
            this.delegate.write(request, (HttpServletResponse)cachingResponseWrapper);
            try {
                if (this.error) {
                    int errorStatusCode = cachingResponseWrapper.getStatus();
                    String errorMessage = cachingResponseWrapper.getErrorMessage();
                    this.responseCache.put(request, this.invocationInput, CachedResponse.ofError(errorStatusCode, errorMessage));
                } else {
                    byte[] contentBytes = cachingResponseWrapper.getContentAsByteArray();
                    this.responseCache.put(request, this.invocationInput, CachedResponse.ofContent(contentBytes));
                }
            }
            catch (Exception t) {
                log.warn("Ignore read from cache, unexpected error happened", (Throwable)t);
            }
            cachingResponseWrapper.flushBuffer();
            cachingResponseWrapper.close();
        } else {
            this.delegate.write(request, response);
        }
    }
}

