/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.servlet.QueryResponseWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchedQueryResponseWriter
implements QueryResponseWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchedQueryResponseWriter.class);
    private final List<ExecutionResult> results;
    private final GraphQLObjectMapper graphQLObjectMapper;

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        ArrayList<byte[]> serializedResults = new ArrayList<byte[]>(2 * this.results.size() + 1);
        if (!this.results.isEmpty()) {
            serializedResults.add("[".getBytes(StandardCharsets.UTF_8));
        } else {
            serializedResults.add("[]".getBytes(StandardCharsets.UTF_8));
        }
        long totalLength = ((byte[])serializedResults.get(0)).length;
        for (int i = 0; i < this.results.size(); ++i) {
            byte[] currentResult = this.graphQLObjectMapper.serializeResultAsBytes(this.results.get(i));
            serializedResults.add(currentResult);
            if (i != this.results.size() - 1) {
                serializedResults.add(",".getBytes(StandardCharsets.UTF_8));
            } else {
                serializedResults.add("]".getBytes(StandardCharsets.UTF_8));
            }
            totalLength += (long)(currentResult.length + 1);
        }
        if (totalLength > Integer.MAX_VALUE) {
            throw new IllegalStateException("Response size exceed 2GiB. Query will fail. Seen size: " + totalLength);
        }
        response.setContentLength((int)totalLength);
        for (byte[] result : serializedResults) {
            response.getOutputStream().write(result);
        }
    }

    @Generated
    public BatchedQueryResponseWriter(List<ExecutionResult> results, GraphQLObjectMapper graphQLObjectMapper) {
        this.results = results;
        this.graphQLObjectMapper = graphQLObjectMapper;
    }
}

