/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.RdbmsSpecifics;

public class MySqlRdbmsSpecifics
implements RdbmsSpecifics {
    public String formatParameter(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            String text = LogUtils.replaceEach((String)object, new String[]{"\\", "$", "'", "\"", "\r", "\n", "\t"}, new String[]{"\\\\\\\\", "\\$", "\\\\'", "\\\\\"", "\\\\r", "\\\\n", "\\\\t"});
            return "'" + text + "'";
        }
        if (object instanceof Timestamp) {
            return "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(object) + "'";
        }
        if (object instanceof Time) {
            return "'" + new SimpleDateFormat("HH:mm:ss").format(object) + "'";
        }
        if (object instanceof Date) {
            return "'" + new SimpleDateFormat("yyyy-MM-dd").format(object) + "'";
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "'1'" : "'0'";
        }
        return object.toString();
    }
}

