/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion;

import com.google.sitebricks.conversion.Converter;
import com.google.sitebricks.conversion.ConverterAdaptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class NumberConverters {
    public static List<Converter<?, ?>> converters() {
        ArrayList converters = new ArrayList();
        converters.add(new ConverterAdaptor<Number, Integer>(){

            @Override
            public Integer to(Number source) {
                return source.intValue();
            }
        });
        converters.add(new ConverterAdaptor<Number, Long>(){

            @Override
            public Long to(Number source) {
                return source.longValue();
            }
        });
        converters.add(new ConverterAdaptor<Number, Float>(){

            @Override
            public Float to(Number source) {
                return Float.valueOf(source.floatValue());
            }
        });
        converters.add(new ConverterAdaptor<Number, Double>(){

            @Override
            public Double to(Number source) {
                return source.doubleValue();
            }
        });
        converters.add(new ConverterAdaptor<Number, Short>(){

            @Override
            public Short to(Number source) {
                return source.shortValue();
            }
        });
        converters.add(new ConverterAdaptor<Number, BigInteger>(){

            @Override
            public BigInteger to(Number source) {
                return BigInteger.valueOf(source.longValue());
            }
        });
        converters.add(new ConverterAdaptor<Number, BigDecimal>(){

            @Override
            public BigDecimal to(Number source) {
                return BigDecimal.valueOf(source.doubleValue());
            }
        });
        return converters;
    }
}

