/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion;

import com.google.inject.Singleton;
import com.google.sitebricks.conversion.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.mvel2.DataConversion;

@Singleton
public class MvelTypeConverter
implements TypeConverter {
    @Override
    public <T> T convert(Object source, Type type) {
        return (T)DataConversion.convert((Object)source, MvelTypeConverter.erase(type));
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (tv.getBounds().length == 0) {
                return Object.class;
            }
            return MvelTypeConverter.erase(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            Class<?> componentType = MvelTypeConverter.erase(aType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }
}

