/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_LiveServerMessage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.LiveServerContent;
import com.google.genai.types.LiveServerGoAway;
import com.google.genai.types.LiveServerSessionResumptionUpdate;
import com.google.genai.types.LiveServerSetupComplete;
import com.google.genai.types.LiveServerToolCall;
import com.google.genai.types.LiveServerToolCallCancellation;
import com.google.genai.types.UsageMetadata;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveServerMessage
extends JsonSerializable {
    @JsonProperty(value="setupComplete")
    public abstract Optional<LiveServerSetupComplete> setupComplete();

    @JsonProperty(value="serverContent")
    public abstract Optional<LiveServerContent> serverContent();

    @JsonProperty(value="toolCall")
    public abstract Optional<LiveServerToolCall> toolCall();

    @JsonProperty(value="toolCallCancellation")
    public abstract Optional<LiveServerToolCallCancellation> toolCallCancellation();

    @JsonProperty(value="usageMetadata")
    public abstract Optional<UsageMetadata> usageMetadata();

    @JsonProperty(value="goAway")
    public abstract Optional<LiveServerGoAway> goAway();

    @JsonProperty(value="sessionResumptionUpdate")
    public abstract Optional<LiveServerSessionResumptionUpdate> sessionResumptionUpdate();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveServerMessage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveServerMessage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveServerMessage.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveServerMessage.Builder();
        }

        @JsonProperty(value="setupComplete")
        public abstract Builder setupComplete(LiveServerSetupComplete var1);

        public Builder setupComplete(LiveServerSetupComplete.Builder setupCompleteBuilder) {
            return this.setupComplete(setupCompleteBuilder.build());
        }

        @JsonProperty(value="serverContent")
        public abstract Builder serverContent(LiveServerContent var1);

        public Builder serverContent(LiveServerContent.Builder serverContentBuilder) {
            return this.serverContent(serverContentBuilder.build());
        }

        @JsonProperty(value="toolCall")
        public abstract Builder toolCall(LiveServerToolCall var1);

        public Builder toolCall(LiveServerToolCall.Builder toolCallBuilder) {
            return this.toolCall(toolCallBuilder.build());
        }

        @JsonProperty(value="toolCallCancellation")
        public abstract Builder toolCallCancellation(LiveServerToolCallCancellation var1);

        public Builder toolCallCancellation(LiveServerToolCallCancellation.Builder toolCallCancellationBuilder) {
            return this.toolCallCancellation(toolCallCancellationBuilder.build());
        }

        @JsonProperty(value="usageMetadata")
        public abstract Builder usageMetadata(UsageMetadata var1);

        public Builder usageMetadata(UsageMetadata.Builder usageMetadataBuilder) {
            return this.usageMetadata(usageMetadataBuilder.build());
        }

        @JsonProperty(value="goAway")
        public abstract Builder goAway(LiveServerGoAway var1);

        public Builder goAway(LiveServerGoAway.Builder goAwayBuilder) {
            return this.goAway(goAwayBuilder.build());
        }

        @JsonProperty(value="sessionResumptionUpdate")
        public abstract Builder sessionResumptionUpdate(LiveServerSessionResumptionUpdate var1);

        public Builder sessionResumptionUpdate(LiveServerSessionResumptionUpdate.Builder sessionResumptionUpdateBuilder) {
            return this.sessionResumptionUpdate(sessionResumptionUpdateBuilder.build());
        }

        public abstract LiveServerMessage build();
    }
}

