/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.Tunings;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CancelTuningJobConfig;
import com.google.genai.types.CreateTuningJobConfig;
import com.google.genai.types.GetTuningJobConfig;
import com.google.genai.types.JobState;
import com.google.genai.types.ListTuningJobsConfig;
import com.google.genai.types.ListTuningJobsResponse;
import com.google.genai.types.PreTunedModel;
import com.google.genai.types.TuningDataset;
import com.google.genai.types.TuningJob;
import com.google.genai.types.TuningOperation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncTunings {
    Tunings tunings;
    ApiClient apiClient;

    public AsyncTunings(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.tunings = new Tunings(apiClient);
    }

    CompletableFuture<TuningJob> privateGet(String name, GetTuningJobConfig config) {
        Common.BuiltRequest builtRequest = this.tunings.buildRequestForPrivateGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                TuningJob tuningJob = this.tunings.processResponseForPrivateGet(res, config);
                return tuningJob;
            }
        });
    }

    CompletableFuture<ListTuningJobsResponse> privateList(ListTuningJobsConfig config) {
        Common.BuiltRequest builtRequest = this.tunings.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListTuningJobsResponse listTuningJobsResponse = this.tunings.processResponseForPrivateList(res, config);
                return listTuningJobsResponse;
            }
        });
    }

    public CompletableFuture<Void> cancel(String name, CancelTuningJobConfig config) {
        Common.BuiltRequest builtRequest = this.tunings.buildRequestForCancel(name, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenAccept(response -> {
            ApiResponse res = response;
            if (res != null) {
                res.close();
            }
        });
    }

    CompletableFuture<TuningJob> privateTune(String baseModel, PreTunedModel preTunedModel, TuningDataset trainingDataset, CreateTuningJobConfig config) {
        Common.BuiltRequest builtRequest = this.tunings.buildRequestForPrivateTune(baseModel, preTunedModel, trainingDataset, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                TuningJob tuningJob = this.tunings.processResponseForPrivateTune(res, config);
                return tuningJob;
            }
        });
    }

    CompletableFuture<TuningOperation> privateTuneMldev(String baseModel, PreTunedModel preTunedModel, TuningDataset trainingDataset, CreateTuningJobConfig config) {
        Common.BuiltRequest builtRequest = this.tunings.buildRequestForPrivateTuneMldev(baseModel, preTunedModel, trainingDataset, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                TuningOperation tuningOperation = this.tunings.processResponseForPrivateTuneMldev(res, config);
                return tuningOperation;
            }
        });
    }

    public CompletableFuture<TuningJob> get(String name, GetTuningJobConfig config) {
        return CompletableFuture.supplyAsync(() -> this.tunings.privateGet(name, config));
    }

    public CompletableFuture<AsyncPager<TuningJob>> list(ListTuningJobsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListTuningJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListTuningJobsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.tunings.privateList((ListTuningJobsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.TUNING_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }

    public CompletableFuture<TuningJob> tune(String baseModel, TuningDataset trainingDataset, CreateTuningJobConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.tunings.apiClient.vertexAI()) {
                if (baseModel.startsWith("projects/")) {
                    PreTunedModel.Builder preTunedModelBuilder = PreTunedModel.builder().tunedModelName(baseModel);
                    if (config != null && config.preTunedModelCheckpointId().isPresent()) {
                        preTunedModelBuilder.checkpointId(config.preTunedModelCheckpointId().get());
                    }
                    return this.tunings.privateTune(null, preTunedModelBuilder.build(), trainingDataset, config);
                }
                return this.tunings.privateTune(baseModel, null, trainingDataset, config);
            }
            TuningOperation operation = this.tunings.privateTuneMldev(baseModel, null, trainingDataset, config);
            String tunedModelName = "";
            if (operation.metadata().isPresent() && operation.metadata().get().containsKey("tunedModel")) {
                tunedModelName = (String)operation.metadata().get().get("tunedModel");
            } else {
                if (!operation.name().isPresent()) {
                    throw new IllegalArgumentException("Operation name is required.");
                }
                tunedModelName = operation.name().get().split("/operations/")[0];
            }
            return TuningJob.builder().name(tunedModelName).state(JobState.Known.JOB_STATE_QUEUED).build();
        });
    }
}

