package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SpeechConfig extends SpeechConfig {

  private final Optional<VoiceConfig> voiceConfig;

  private final Optional<MultiSpeakerVoiceConfig> multiSpeakerVoiceConfig;

  private final Optional<String> languageCode;

  private AutoValue_SpeechConfig(
      Optional<VoiceConfig> voiceConfig,
      Optional<MultiSpeakerVoiceConfig> multiSpeakerVoiceConfig,
      Optional<String> languageCode) {
    this.voiceConfig = voiceConfig;
    this.multiSpeakerVoiceConfig = multiSpeakerVoiceConfig;
    this.languageCode = languageCode;
  }

  @JsonProperty("voiceConfig")
  @Override
  public Optional<VoiceConfig> voiceConfig() {
    return voiceConfig;
  }

  @JsonProperty("multiSpeakerVoiceConfig")
  @Override
  public Optional<MultiSpeakerVoiceConfig> multiSpeakerVoiceConfig() {
    return multiSpeakerVoiceConfig;
  }

  @JsonProperty("languageCode")
  @Override
  public Optional<String> languageCode() {
    return languageCode;
  }

  @Override
  public String toString() {
    return "SpeechConfig{"
        + "voiceConfig=" + voiceConfig + ", "
        + "multiSpeakerVoiceConfig=" + multiSpeakerVoiceConfig + ", "
        + "languageCode=" + languageCode
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SpeechConfig) {
      SpeechConfig that = (SpeechConfig) o;
      return this.voiceConfig.equals(that.voiceConfig())
          && this.multiSpeakerVoiceConfig.equals(that.multiSpeakerVoiceConfig())
          && this.languageCode.equals(that.languageCode());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= voiceConfig.hashCode();
    h$ *= 1000003;
    h$ ^= multiSpeakerVoiceConfig.hashCode();
    h$ *= 1000003;
    h$ ^= languageCode.hashCode();
    return h$;
  }

  @Override
  public SpeechConfig.Builder toBuilder() {
    return new AutoValue_SpeechConfig.Builder(this);
  }

  static final class Builder extends SpeechConfig.Builder {
    private Optional<VoiceConfig> voiceConfig = Optional.empty();
    private Optional<MultiSpeakerVoiceConfig> multiSpeakerVoiceConfig = Optional.empty();
    private Optional<String> languageCode = Optional.empty();
    Builder() {
    }
    Builder(SpeechConfig source) {
      this.voiceConfig = source.voiceConfig();
      this.multiSpeakerVoiceConfig = source.multiSpeakerVoiceConfig();
      this.languageCode = source.languageCode();
    }
    @Override
    public SpeechConfig.Builder voiceConfig(VoiceConfig voiceConfig) {
      this.voiceConfig = Optional.of(voiceConfig);
      return this;
    }
    @Override
    public SpeechConfig.Builder multiSpeakerVoiceConfig(MultiSpeakerVoiceConfig multiSpeakerVoiceConfig) {
      this.multiSpeakerVoiceConfig = Optional.of(multiSpeakerVoiceConfig);
      return this;
    }
    @Override
    public SpeechConfig.Builder languageCode(String languageCode) {
      this.languageCode = Optional.of(languageCode);
      return this;
    }
    @Override
    public SpeechConfig build() {
      return new AutoValue_SpeechConfig(
          this.voiceConfig,
          this.multiSpeakerVoiceConfig,
          this.languageCode);
    }
  }

}
