/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import java.util.concurrent.Executor;

class OnSuccessCompletionListener<TResult>
implements TaskCompletionListener<TResult> {
    private final Executor mExecutor;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private OnSuccessListener<? super TResult> mOnSuccess;

    public OnSuccessCompletionListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccess) {
        this.mExecutor = executor;
        this.mOnSuccess = onSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(final @NonNull Task<TResult> task) {
        if (task.isSuccessful()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mOnSuccess == null) {
                    return;
                }
            }
            this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = OnSuccessCompletionListener.this.mLock;
                    synchronized (object) {
                        if (OnSuccessCompletionListener.this.mOnSuccess != null) {
                            OnSuccessCompletionListener.this.mOnSuccess.onSuccess(task.getResult());
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnSuccess = null;
        }
    }
}

