/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseAppStore {
    private static final AtomicReference<FirebaseAppStore> sInstance = new AtomicReference();

    @Nullable
    public static FirebaseAppStore getInstance() {
        return sInstance.get();
    }

    public static FirebaseAppStore initialize() {
        sInstance.compareAndSet(null, new FirebaseAppStore());
        return sInstance.get();
    }

    FirebaseAppStore() {
    }

    public static void setInstanceForTest(FirebaseAppStore firebaseAppStore) {
        sInstance.set(firebaseAppStore);
    }

    @VisibleForTesting
    public static void clearInstanceForTest() {
        FirebaseAppStore instance = sInstance.get();
        if (instance != null) {
            instance.resetStore();
        }
        sInstance.set(null);
    }

    public Set<String> getAllPersistedAppNames() {
        return Collections.emptySet();
    }

    public void persistApp(@NonNull FirebaseApp app) {
    }

    public void removeApp(@NonNull String name) {
    }

    public FirebaseOptions restoreAppOptions(@NonNull String name) {
        return null;
    }

    protected void resetStore() {
    }
}

