/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.view.Event;

public class DataEvent
implements Event {
    private final Event.EventType eventType;
    private final EventRegistration eventRegistration;
    private final DataSnapshot snapshot;
    private final String prevName;

    public DataEvent(Event.EventType eventType, EventRegistration eventRegistration, DataSnapshot snapshot, String prevName) {
        this.eventType = eventType;
        this.eventRegistration = eventRegistration;
        this.snapshot = snapshot;
        this.prevName = prevName;
    }

    @Override
    public Path getPath() {
        Path path = this.snapshot.getRef().getPath();
        if (this.eventType == Event.EventType.VALUE) {
            return path;
        }
        return path.getParent();
    }

    public DataSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getPreviousName() {
        return this.prevName;
    }

    public Event.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public void fire() {
        this.eventRegistration.fireEvent(this);
    }

    @Override
    public String toString() {
        if (this.eventType == Event.EventType.VALUE) {
            String string = String.valueOf(this.getPath());
            String string2 = String.valueOf((Object)this.eventType);
            String string3 = String.valueOf(this.snapshot.getValue(true));
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(": ").append(string2).append(": ").append(string3).toString();
        }
        String string = String.valueOf(this.getPath());
        String string4 = String.valueOf((Object)this.eventType);
        String string5 = String.valueOf(this.snapshot.getKey());
        String string6 = String.valueOf(this.snapshot.getValue(true));
        return new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string).append(": ").append(string4).append(": { ").append(string5).append(": ").append(string6).append(" }").toString();
    }
}

