/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import java.net.URI;

public class HostInfo {
    private static final String VERSION_PARAM = "v";
    private static final String LAST_SESSION_ID_PARAM = "ls";
    private final String host;
    private final String namespace;
    private final boolean secure;

    public HostInfo(String host, String namespace, boolean secure) {
        this.host = host;
        this.namespace = namespace;
        this.secure = secure;
    }

    public String toString() {
        String string = this.secure ? "s" : "";
        String string2 = this.host;
        return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append("http").append(string).append("://").append(string2).toString();
    }

    public static URI getConnectionUrl(String host, boolean secure, String namespace, String optLastSessionId) {
        String scheme = secure ? "wss" : "ws";
        String string = String.valueOf(VERSION_PARAM);
        String string2 = String.valueOf("5");
        String url = new StringBuilder(13 + String.valueOf(scheme).length() + String.valueOf(host).length() + String.valueOf(namespace).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(scheme).append("://").append(host).append("/.ws?ns=").append(namespace).append("&").append(string).append("=").append(string2).toString();
        if (optLastSessionId != null) {
            string = String.valueOf(url);
            string2 = String.valueOf("&ls=");
            url = new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(optLastSessionId).length()).append(string).append(string2).append(optLastSessionId).toString();
        }
        return URI.create(url);
    }

    public String getHost() {
        return this.host;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

