/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ByteStreams;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class FirebaseOptions {
    private final String mDatabaseUrl;
    private final GoogleCredential mServiceAccountCredential;
    private final String mProjectId;
    private final Map<String, Object> mDatabaseAuthVariableOverride;

    private FirebaseOptions(@Nullable String databaseUrl, @NonNull GoogleCredential serviceAccountCredential, @Nullable String projectId, @Nullable Map<String, Object> databaseAuthVariableOverride) {
        Preconditions.checkState(serviceAccountCredential != null, "Service Account must be provided.");
        this.mDatabaseUrl = databaseUrl;
        this.mServiceAccountCredential = serviceAccountCredential;
        this.mProjectId = projectId;
        this.mDatabaseAuthVariableOverride = databaseAuthVariableOverride;
    }

    public String getDatabaseUrl() {
        return this.mDatabaseUrl;
    }

    String getProjectId() {
        return this.mProjectId;
    }

    GoogleCredential getServiceAccountCredential() {
        return this.mServiceAccountCredential;
    }

    public Map<String, Object> getDatabaseAuthVariableOverride() {
        return this.mDatabaseAuthVariableOverride;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions other = (FirebaseOptions)o;
        return Objects.equal(this.mDatabaseUrl, other.mDatabaseUrl) && Objects.equal(this.mServiceAccountCredential.getServiceAccountId(), other.mServiceAccountCredential.getServiceAccountId()) && Objects.equal(this.mProjectId, other.mProjectId) && Objects.equal(this.mDatabaseAuthVariableOverride, other.mDatabaseAuthVariableOverride);
    }

    public int hashCode() {
        return Objects.hashCode(this.mDatabaseUrl, this.mServiceAccountCredential, this.mProjectId, this.mDatabaseAuthVariableOverride);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("databaseUrl", this.mDatabaseUrl).add("serviceAccount", this.mServiceAccountCredential).add("projectId", this.mProjectId).add("databaseAuthVariableOverride", this.mDatabaseAuthVariableOverride).toString();
    }

    public static final class Builder {
        private String mDatabaseUrl;
        private GoogleCredential mServiceAccountCredential;
        private String mProjectId;
        private Map<String, Object> mDatabaseAuthVariableOverride = new HashMap<String, Object>();

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.mDatabaseUrl = options.mDatabaseUrl;
            this.mServiceAccountCredential = options.mServiceAccountCredential;
            this.mProjectId = options.mProjectId;
            this.mDatabaseAuthVariableOverride = options.mDatabaseAuthVariableOverride;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.mDatabaseUrl = databaseUrl;
            return this;
        }

        public Builder setServiceAccount(@NonNull InputStream stream) {
            try {
                ByteArrayOutputStream streamCopy = new ByteArrayOutputStream();
                ByteStreams.copy((InputStream)stream, (OutputStream)streamCopy);
                stream.close();
                JSONObject jsonData = new JSONObject(streamCopy.toString());
                this.setProjectId(jsonData.getString("project_id"));
                this.mServiceAccountCredential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(streamCopy.toByteArray()), (HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance());
            }
            catch (IOException | JSONException e) {
                throw new RuntimeException("Failed to read service account", e);
            }
            return this;
        }

        Builder setProjectId(@NonNull String projectId) {
            this.mProjectId = projectId;
            return this;
        }

        public Builder setDatabaseAuthVariableOverride(@Nullable Map<String, Object> databaseAuthVariableOverride) {
            this.mDatabaseAuthVariableOverride = databaseAuthVariableOverride;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.mDatabaseUrl, this.mServiceAccountCredential, this.mProjectId, this.mDatabaseAuthVariableOverride);
        }
    }
}

