/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.model.AutoValue_ComponentPath;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class ComponentPath {
    public static ComponentPath create(Iterable<TypeElement> components) {
        return new AutoValue_ComponentPath((ImmutableList<TypeElement>)ImmutableList.copyOf(components));
    }

    public abstract ImmutableList<TypeElement> components();

    public final TypeElement rootComponent() {
        return (TypeElement)this.components().get(0);
    }

    @Memoized
    public TypeElement currentComponent() {
        return (TypeElement)Iterables.getLast(this.components());
    }

    public final TypeElement parentComponent() {
        Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
        return (TypeElement)this.components().reverse().get(1);
    }

    public final ComponentPath parent() {
        Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
        return ComponentPath.create((Iterable<TypeElement>)this.components().subList(0, this.components().size() - 1));
    }

    public final ComponentPath childPath(TypeElement child) {
        return ComponentPath.create((Iterable<TypeElement>)ImmutableList.builder().addAll(this.components()).add((Object)child).build());
    }

    public final boolean atRoot() {
        return this.components().size() == 1;
    }

    public final String toString() {
        return this.components().stream().map(TypeElement::getQualifiedName).collect(Collectors.joining(" \u2192 "));
    }

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

