/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class ModuleProxies {
    private ModuleProxies() {
    }

    private static XClassName constructorProxyTypeName(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        XClassName moduleClassName = moduleElement.asClassName();
        return moduleClassName.topLevelClass().peerClass(SourceFiles.classFileName(moduleClassName) + "_Proxy");
    }

    private static Optional<XConstructorElement> nonPublicNullaryConstructor(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        if (!ComponentRequirement.requiresModuleInstance(moduleElement) || moduleElement.isAbstract() || XTypeElements.isNested(moduleElement) && !moduleElement.isStatic()) {
            return Optional.empty();
        }
        return moduleElement.getConstructors().stream().filter(constructor -> !Accessibility.isElementPubliclyAccessible(constructor)).filter(constructor -> !constructor.isPrivate()).filter(constructor -> constructor.getParameters().isEmpty()).findAny();
    }

    public static XCodeBlock newModuleInstance(XTypeElement moduleElement, XClassName requestingClass) {
        ModuleKind.checkIsModule(moduleElement);
        String packageName = requestingClass.getPackageName();
        XClassName constructorProxyClassName = ModuleProxies.constructorProxyTypeName(moduleElement);
        return ModuleProxies.nonPublicNullaryConstructor(moduleElement).filter(constructor -> !Accessibility.isElementAccessibleFrom((XElement)constructor, packageName)).map(constructor -> XCodeBlock.of("%T.newInstance()", constructorProxyClassName)).orElse(XCodeBlock.ofNewInstance(moduleElement.asClassName(), "", new Object[0]));
    }

    public static final class ModuleConstructorProxyGenerator
    extends SourceFileGenerator<XTypeElement> {
        @Inject
        ModuleConstructorProxyGenerator(XFiler filer, XProcessingEnv processingEnv) {
            super(filer, processingEnv);
        }

        @Override
        public XElement originatingElement(XTypeElement moduleElement) {
            return moduleElement;
        }

        @Override
        public ImmutableList<XTypeSpec> topLevelTypes(XTypeElement moduleElement) {
            ModuleKind.checkIsModule(moduleElement);
            return ModuleProxies.nonPublicNullaryConstructor(moduleElement).isPresent() ? ImmutableList.of((Object)this.buildProxy(moduleElement)) : ImmutableList.of();
        }

        private XTypeSpec buildProxy(XTypeElement moduleElement) {
            return XTypeSpecs.classBuilder(ModuleProxies.constructorProxyTypeName(moduleElement)).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addFunction(XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).build()).addFunction(XFunSpecs.methodBuilder("newInstance").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(moduleElement.asClassName()).addStatement("return %L", XCodeBlock.ofNewInstance(moduleElement.asClassName(), "", new Object[0])).build()).build();
        }
    }
}

