/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.NullableTypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;

public final class FrameworkField {
    private final String name;
    private final XTypeName type;

    public static FrameworkField create(String fieldName, XClassName frameworkClassName, XType type, CompilerOptions compilerOptions) {
        return FrameworkField.create(fieldName, frameworkClassName, Optional.of(type), compilerOptions);
    }

    public static FrameworkField create(String fieldName, XClassName frameworkClassName, Optional<XType> type, CompilerOptions compilerOptions) {
        return FrameworkField.createInternal(fieldName, frameworkClassName, type, Nullability.NOT_NULLABLE, compilerOptions);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<XClassName> frameworkClassName, CompilerOptions compilerOptions) {
        return FrameworkField.createInternal(FrameworkField.bindingName(binding), frameworkClassName.orElse(binding.frameworkType().frameworkClassName()), FrameworkField.bindingType(binding), binding.nullability(), compilerOptions);
    }

    private static String bindingName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = FrameworkField.bindingElementName(binding.bindingElement().get());
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    private static Optional<XType> bindingType(ContributionBinding binding) {
        if (binding.contributionType().isMultibinding()) {
            return Optional.of(binding.contributedType());
        }
        if (MapType.isMapOfProvider(binding.contributedType())) {
            return Optional.empty();
        }
        return Optional.of(binding.key().type().xprocessing());
    }

    private static FrameworkField createInternal(String fieldName, XClassName frameworkClassName, Optional<XType> type, Nullability nullability, CompilerOptions compilerOptions) {
        return new FrameworkField(FrameworkField.frameworkFieldName(fieldName, frameworkClassName), FrameworkField.frameworkFieldType(frameworkClassName, type, nullability, compilerOptions));
    }

    private static XTypeName frameworkFieldType(XClassName frameworkClassName, Optional<XType> type, Nullability nullability, CompilerOptions compilerOptions) {
        if (type.isEmpty()) {
            return frameworkClassName;
        }
        return frameworkClassName.parametrizedBy(NullableTypeNames.asNullableTypeName(type.get().asTypeName(), nullability, compilerOptions));
    }

    private static String frameworkFieldName(String fieldName, XClassName frameworkClassName) {
        String suffix = (String)Iterables.getLast(frameworkClassName.getSimpleNames());
        return fieldName.endsWith(suffix) ? fieldName : fieldName + suffix;
    }

    private static String bindingElementName(XElement bindingElement) {
        if (XElementKt.isConstructor(bindingElement)) {
            return FrameworkField.bindingElementName(bindingElement.getEnclosingElement());
        }
        if (XElementKt.isMethod(bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        if (XElementKt.isTypeElement(bindingElement)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName(bindingElement));
        }
        if (XElementKt.isMethodParameter(bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        throw new IllegalArgumentException("Unexpected binding " + bindingElement);
    }

    FrameworkField(String name, XTypeName type) {
        this.name = name;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public XTypeName type() {
        return this.type;
    }
}

