/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

final class ImmediateFutureRequestRepresentation
extends RequestRepresentation {
    private final RequestRepresentation instanceRequestRepresentation;
    private final XType type;
    private final XProcessingEnv processingEnv;

    @AssistedInject
    ImmediateFutureRequestRepresentation(@Assisted RequestRepresentation instanceRequestRepresentation, @Assisted XType type, XProcessingEnv processingEnv) {
        this.instanceRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)instanceRequestRepresentation);
        this.type = (XType)Preconditions.checkNotNull((Object)type);
        this.processingEnv = processingEnv;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return Expression.create(XProcessingEnvs.wrapType(TypeNames.LISTENABLE_FUTURE, this.type, this.processingEnv), CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.instanceExpression(requestingClass)}));
    }

    private CodeBlock instanceExpression(ClassName requestingClass) {
        Expression expression = this.instanceRequestRepresentation.getDependencyExpression(requestingClass);
        if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && !expression.type().isSameType(this.type)) {
            return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{Accessibility.accessibleTypeName(this.type, requestingClass, this.processingEnv), expression.codeBlock()});
        }
        return expression.codeBlock();
    }

    @AssistedFactory
    static interface Factory {
        public ImmediateFutureRequestRepresentation create(RequestRepresentation var1, XType var2);
    }
}

